/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion;

import dev.ftb.packcompanion.PackCompanion;
import dev.ftb.packcompanion.core.DataGatherCollector;
import dev.ftb.packcompanion.core.Feature;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosDataProvider;

public record PackCompanionDataGen(PackCompanion modInstance) {
    public void onInitializeDataGenerator(GatherDataEvent event) {
        PackOutput packOutput = event.getGenerator().getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGatherCollector collector = new DataGatherCollector();
        for (Feature feature : this.modInstance.features()) {
            feature.onDataGather(collector);
        }
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        generator.addProvider(true, (DataProvider)new Lang(output, collector));
        generator.addProvider(true, (DataProvider)new BlockStateGen(packOutput, existingFileHelper, collector.blockStateProviders()));
        generator.addProvider(true, (DataProvider)new ItemModelGen(packOutput, existingFileHelper, collector.itemModelProviders()));
        BlockTagGen blockTagProvider = new BlockTagGen(packOutput, event.getLookupProvider(), existingFileHelper, collector);
        generator.addProvider(true, (DataProvider)blockTagProvider);
        generator.addProvider(true, (DataProvider)new ItemTagGen(packOutput, event.getLookupProvider(), blockTagProvider.contentsGetter(), existingFileHelper, collector));
        generator.addProvider(true, (DataProvider)new CuriosDataGen(packOutput, existingFileHelper, event.getLookupProvider()));
    }

    private static class Lang
    extends LanguageProvider {
        final DataGatherCollector collector;

        public Lang(PackOutput output, DataGatherCollector collector) {
            super(output, "ftbpc", "en_us");
            this.collector = collector;
        }

        protected void addTranslations() {
            this.collector.translationCollector().translations().forEach((arg_0, arg_1) -> ((Lang)this).add(arg_0, arg_1));
        }
    }

    private static class BlockStateGen
    extends BlockStateProvider {
        private final List<Consumer<BlockStateProvider>> blockStateProviders;

        public BlockStateGen(PackOutput output, ExistingFileHelper exFileHelper, List<Consumer<BlockStateProvider>> consumers) {
            super(output, "ftbpc", exFileHelper);
            this.blockStateProviders = consumers;
        }

        protected void registerStatesAndModels() {
            for (Consumer<BlockStateProvider> consumer : this.blockStateProviders) {
                consumer.accept(this);
            }
        }
    }

    private static class ItemModelGen
    extends ItemModelProvider {
        private final List<Consumer<ItemModelProvider>> itemModelProviders;

        public ItemModelGen(PackOutput output, ExistingFileHelper existingFileHelper, List<Consumer<ItemModelProvider>> consumers) {
            super(output, "ftbpc", existingFileHelper);
            this.itemModelProviders = consumers;
        }

        protected void registerModels() {
            for (Consumer<ItemModelProvider> consumer : this.itemModelProviders) {
                consumer.accept(this);
            }
        }
    }

    public static class BlockTagGen
    extends BlockTagsProvider {
        private final List<Consumer<BlockTagGen>> blockStateProviders;

        public BlockTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper, DataGatherCollector collector) {
            super(output, lookupProvider, "ftbpc", existingFileHelper);
            this.blockStateProviders = collector.blockTagProviders();
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (Consumer<BlockTagGen> consumer : this.blockStateProviders) {
                consumer.accept(this);
            }
        }

        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> appendBlockTag(TagKey<Block> tag) {
            return this.tag(tag);
        }
    }

    public static class ItemTagGen
    extends ItemTagsProvider {
        private final List<Consumer<ItemTagGen>> itemTagProviders;

        public ItemTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper, DataGatherCollector collector) {
            super(output, lookupProvider, blockTags, "ftbpc", existingFileHelper);
            this.itemTagProviders = collector.itemTagProviders();
        }

        protected void addTags(HolderLookup.Provider provider) {
            for (Consumer<ItemTagGen> consumer : this.itemTagProviders) {
                consumer.accept(this);
            }
        }

        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> appendItemTag(TagKey<Item> tag) {
            return this.tag(tag);
        }
    }

    private static class CuriosDataGen
    extends CuriosDataProvider {
        public CuriosDataGen(PackOutput output, ExistingFileHelper fileHelper, CompletableFuture<HolderLookup.Provider> registries) {
            super("ftbpc", output, fileHelper, registries);
        }

        public void generate(HolderLookup.Provider registries, ExistingFileHelper fileHelper) {
            this.createEntities("curio").addPlayer().addSlots(new String[]{"curio"});
        }
    }
}

