/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.integrations.fancymenu;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import dev.ftb.packcompanion.PackCompanion;
import java.time.LocalTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HourLessThanReq
extends LoadingRequirement {
    public HourLessThanReq() {
        super(PackCompanion.id("hour_less_than").toString().replace(":", "_"));
    }

    public boolean hasValue() {
        return true;
    }

    public boolean isRequirementMet(@Nullable String input) {
        int number;
        int n = number = input != null ? Integer.parseInt(input) : -1;
        if (number == -1) {
            return false;
        }
        int currentHour = LocalTime.now().getHour();
        return currentHour < number;
    }

    @NotNull
    public String getDisplayName() {
        return "Hour Less Than";
    }

    @Nullable
    public List<String> getDescription() {
        return List.of("Checks if the users current hour is less than the specified value.", "The value must be a number between 0 and 23, representing the hour in 24-hour format.");
    }

    @Nullable
    public String getCategory() {
        return "FTB Pack Companion";
    }

    @Nullable
    public String getValueDisplayName() {
        return "Hour (0-23)";
    }

    @Nullable
    public String getValuePreset() {
        return null;
    }

    @Nullable
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return List.of();
    }
}

