/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.api.PromoResponse;
import dev.ftb.mods.promoter.api.requirements.Requirement;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoFetcher.class);
    private static final InfoFetcher INSTANCE = new InfoFetcher();
    private static final String API_URL = "https://api.feed-the-beast.com/v1/meta/promotions";
    private final List<PromoData> promotions = Collections.synchronizedList(new ArrayList());
    private boolean isFirstGet = true;

    private InfoFetcher() {
    }

    public static InfoFetcher get() {
        return INSTANCE;
    }

    public void load() {
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL)).GET().build();
            ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(data -> {
                try {
                    GsonBuilder builder = new GsonBuilder();
                    builder.registerTypeAdapter(Requirement.class, (Object)new Requirement.RequirementDeserializer());
                    Gson gson = builder.create();
                    PromoResponse responseObj = (PromoResponse)gson.fromJson(data, PromoResponse.class);
                    this.promotions.addAll(responseObj.promotions());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse response", (Throwable)e);
                }
            })).exceptionally(e -> {
                LOGGER.error("Failed to fetch promotions", e);
                return null;
            });
        }
    }

    public List<PromoData> getPromotions() {
        if (this.isFirstGet) {
            this.isFirstGet = false;
            this.refineList();
        }
        return this.promotions;
    }

    public void refineList() {
        if (this.promotions.isEmpty()) {
            return;
        }
        ArrayList<PromoData> cloneData = new ArrayList<PromoData>(this.promotions);
        for (PromoData data : cloneData) {
            List<Requirement> requirements = data.requirements();
            if (requirements == null || data.requirements().isEmpty()) continue;
            boolean passes = true;
            for (Requirement requirement : requirements) {
                if (requirement.test(data)) continue;
                passes = false;
                break;
            }
            if (passes) continue;
            this.promotions.remove(data);
        }
    }
}

