/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.api.requirements;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.api.requirements.Requirement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.SharedConstants;

public class MinecraftRequirement
extends Requirement {
    private List<String> versions;
    private boolean invert;

    @Override
    public boolean test(PromoData data) {
        String minecraftVersion = SharedConstants.getCurrentVersion().getId();
        if (this.invert) {
            for (String version : this.versions) {
                if (!minecraftVersion.equals(version)) continue;
                return false;
            }
            return true;
        }
        for (String version : this.versions) {
            if (!minecraftVersion.equals(version)) continue;
            return true;
        }
        return false;
    }

    public static MinecraftRequirement deserialize(String type, JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        ArrayList<String> versions = new ArrayList<String>();
        JsonArray rawVersions = json.getAsJsonObject().get("versions").getAsJsonArray();
        for (JsonElement version : rawVersions) {
            versions.add(version.getAsString());
        }
        boolean invert = false;
        if (json.getAsJsonObject().has("invert")) {
            invert = json.getAsJsonObject().get("invert").getAsBoolean();
        }
        MinecraftRequirement requirement = new MinecraftRequirement();
        requirement.type = type;
        requirement.versions = versions;
        requirement.invert = invert;
        return requirement;
    }
}

