/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.integrations.fancymenu;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import dev.ftb.mods.promoter.api.InfoFetcher;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PromoAvailableLoadingReq
extends LoadingRequirement {
    private static final HashMap<String, Boolean> PROMO_AVAILABLE_CACHE = new HashMap();

    public PromoAvailableLoadingReq() {
        super(ResourceLocation.fromNamespaceAndPath((String)"ftbpromoter", (String)"promo_available").toString().replace(":", "_"));
    }

    public boolean hasValue() {
        return true;
    }

    public boolean isRequirementMet(@Nullable String s) {
        if (s == null) {
            return false;
        }
        return PROMO_AVAILABLE_CACHE.computeIfAbsent(s, uuid -> InfoFetcher.get().getPromotions().stream().anyMatch(e -> e.uuid().toString().equals(uuid)));
    }

    @NotNull
    public String getDisplayName() {
        return "Is FTB Promotional Available";
    }

    @Nullable
    public List<String> getDescription() {
        return List.of("Checks if a promo is available from the API.");
    }

    @Nullable
    public String getCategory() {
        return null;
    }

    @Nullable
    public String getValueDisplayName() {
        return "Promotion UUID";
    }

    @Nullable
    public String getValuePreset() {
        return "";
    }

    @Nullable
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return List.of();
    }
}

