/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.screen;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTexture {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteTexture.class);
    public static final Set<ResourceLocation> LOADED_TEXTURES = new HashSet<ResourceLocation>();
    private static final ResourceLocation MISSING_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_server.png");
    private final TextureManager textureManager;
    private final ResourceLocation textureLocation;
    private final String textureLocalName;
    private boolean ready = false;
    private final URI url;

    public RemoteTexture(URI uri, String textureLocalName, TextureManager textureManager) {
        this.url = uri;
        this.textureLocalName = textureLocalName;
        this.textureManager = textureManager;
        this.textureLocation = ResourceLocation.fromNamespaceAndPath((String)"ftbpromoter", (String)("promos/" + textureLocalName));
        this.uploadTexture();
    }

    public void uploadTexture() {
        if (LOADED_TEXTURES.contains(this.textureLocation)) {
            this.ready = true;
            return;
        }
        if (!this.url.getHost().equals("cdn.feed-the-beast.com")) {
            return;
        }
        if (!this.url.getScheme().equals("https")) {
            return;
        }
        Path root = FMLPaths.GAMEDIR.get().resolve("downloads/promos");
        File file = new File(root.toFile(), this.textureLocalName);
        this.textureManager.register(this.textureLocation, (AbstractTexture)new HttpTexture(file, this.url.toString(), MISSING_LOCATION, false, () -> {
            this.ready = true;
            LOADED_TEXTURES.add(this.textureLocation);
        }));
    }

    public ResourceLocation getTextureLocation() {
        return this.ready ? this.textureLocation : MISSING_LOCATION;
    }
}

