/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.dripper;

import dev.ftb.mods.ftbstuffnthings.blocks.dripper.DripperBlock;
import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.crafting.RecipeCaches;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.DripperRecipe;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class DripperBlockEntity
extends BlockEntity {
    private final FluidTank tank = new FluidTank(4000){

        protected void onContentsChanged() {
            DripperBlockEntity.this.fluidChanged();
        }
    };
    private Fluid prevFluid = null;

    public DripperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesRegistry.DRIPPER.get(), pos, state);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void writeData(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put("Tank", (Tag)this.tank.writeToNBT(provider, new CompoundTag()));
    }

    public void readData(CompoundTag tag, HolderLookup.Provider provider) {
        this.tank.readFromNBT(provider, tag.getCompound("Tank"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.writeData(tag, provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.readData(tag, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.saveAdditional((CompoundTag)tag, provider));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void fluidChanged() {
        this.setChanged();
        if (!this.level.isClientSide() && this.prevFluid != this.tank.getFluid().getFluid()) {
            this.prevFluid = this.tank.getFluid().getFluid();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
        }
    }

    public void serverTick(ServerLevel serverLevel) {
        if (serverLevel.getGameTime() % 20L == 0L) {
            FluidState state = serverLevel.getFluidState(this.getBlockPos().above());
            if (state.is(Tags.Fluids.WATER) && state.isSource()) {
                this.tank.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!this.tank.isEmpty()) {
                RecipeHolder currentRecipe = RecipeCaches.DRIPPER.getCachedRecipe(this::searchForRecipe, this::genRecipeHash).orElse(null);
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DripperBlock.ACTIVE, (Comparable)Boolean.valueOf(!this.tank.getFluid().isEmpty() && currentRecipe != null)), 3);
                if (currentRecipe != null) {
                    DripperRecipe recipe = (DripperRecipe)currentRecipe.value();
                    boolean success = false;
                    if (this.tank.getFluidAmount() >= recipe.getFluid().getAmount()) {
                        if (serverLevel.random.nextDouble() < recipe.getChance()) {
                            this.level.setBlock(this.getBlockPos().below(), recipe.getOutputState(), 3);
                            success = true;
                        }
                        if (success || recipe.consumeFluidOnFail()) {
                            this.tank.drain(recipe.getFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                }
            }
        }
    }

    private int genRecipeHash() {
        int fluidHash = FluidStack.hashFluidAndComponents((FluidStack)this.tank.getFluid());
        BlockState blockBelow = this.getLevel().getBlockState(this.getBlockPos().below());
        return Objects.hash(fluidHash, blockBelow);
    }

    private Optional<RecipeHolder<DripperRecipe>> searchForRecipe() {
        return this.level.getRecipeManager().getRecipesFor(RecipesRegistry.DRIP_TYPE.get(), (RecipeInput)NoInventory.INSTANCE, this.level).stream().filter(r -> ((DripperRecipe)r.value()).testInput(this.tank.getFluid(), this.getLevel(), this.getBlockPos().below())).findFirst();
    }
}

