/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.jar;

import dev.ftb.mods.ftbstuffnthings.blocks.SerializableComponentsProvider;
import dev.ftb.mods.ftbstuffnthings.blocks.jar.JarBlockEntity;
import dev.ftb.mods.ftbstuffnthings.registry.ComponentsRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import dev.ftb.mods.ftbstuffnthings.util.MiscUtil;
import dev.ftb.mods.ftbstuffnthings.util.VoxelShapeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.jetbrains.annotations.Nullable;

public class JarBlock
extends Block
implements EntityBlock,
SerializableComponentsProvider {
    public static final VoxelShape SHAPE = VoxelShapeUtils.or(JarBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), JarBlock.box((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), JarBlock.box((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));

    public JarBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.BONE_BLOCK).strength(0.6f).noOcclusion());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new JarBlockEntity(blockPos, blockState);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int n;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof JarBlockEntity) {
            JarBlockEntity jar = (JarBlockEntity)blockEntity;
            n = jar.getComparatorSignal();
        } else {
            n = 0;
        }
        return n;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            level.updateNeighbourForOutputSignal(pos, (Block)this);
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileEntity;
        ItemStack item = player.getItemInHand(hand);
        if (hitResult.getDirection() == Direction.UP && item.getItem() == ItemsRegistry.TUBE.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide() && (tileEntity = level.getBlockEntity(pos)) instanceof JarBlockEntity) {
            JarBlockEntity jar = (JarBlockEntity)tileEntity;
            jar.onRightClick(player, hand, item);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        list.add(ComponentsRegistry.STORED_FLUID.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        FluidStack content = ((SimpleFluidContent)stack.getOrDefault(ComponentsRegistry.STORED_FLUID, (Object)SimpleFluidContent.EMPTY)).copy();
        if (!content.isEmpty()) {
            tooltipComponents.add(MiscUtil.makeFluidStackDesc(content));
        }
    }
}

