/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.jar;

import dev.ftb.mods.ftbstuffnthings.blocks.jar.TemperedJarBlockEntity;
import dev.ftb.mods.ftbstuffnthings.registry.BlockEntitiesRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ContentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.SlotItemHandler;

public class TemperedJarMenu
extends AbstractContainerMenu {
    public static final int PLAYER_INV_Y = 132;
    public static final int INPUT_ITEMS_Y = 36;
    private final TemperedJarBlockEntity jar;

    public static TemperedJarMenu fromNetwork(int containerId, Inventory invPlayer, FriendlyByteBuf extraData) {
        TemperedJarMenu menu = new TemperedJarMenu(containerId, invPlayer, extraData.readBlockPos());
        ResourceLocation recipeId = extraData.readOptional(FriendlyByteBuf::readResourceLocation).orElse(null);
        menu.getJar().setCurrentRecipeId(recipeId);
        return menu;
    }

    public TemperedJarMenu(int containerId, Inventory invPlayer, BlockPos blockPos) {
        super(ContentRegistry.TEMPERED_JAR_MENU.get(), containerId);
        int y;
        this.jar = (TemperedJarBlockEntity)((Object)invPlayer.player.level().getBlockEntity(blockPos, (BlockEntityType)BlockEntitiesRegistry.TEMPERED_JAR.get()).orElseThrow(() -> new IllegalStateException("tempered jar missing at " + String.valueOf(blockPos))));
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slot = 9 + y * 9 + x;
                this.addSlot(new Slot((Container)invPlayer, slot, 8 + x * 18, 132 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)invPlayer, x, 8 + x * 18, 190));
        }
        for (y = 0; y < 3; ++y) {
            this.addSlot((Slot)new SlotItemHandler(this.jar.getInputItemHandler(), y, 17, 36 + 18 * y));
        }
        this.addDataSlots(this.jar.getContainerData());
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            resultStack = stackInSlot.copy();
            if (index < 36 ? !this.moveItemStackTo(stackInSlot, 36, 39, false) : !this.moveItemStackTo(stackInSlot, 27, 36, false) && !this.moveItemStackTo(stackInSlot, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return resultStack;
    }

    public boolean stillValid(Player player) {
        return !this.jar.isRemoved() && player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.jar.getBlockPos())) < 64.0;
    }

    public TemperedJarBlockEntity getJar() {
        return this.jar;
    }
}

