/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.blocks.woodbasin;

import dev.ftb.mods.ftbstuffnthings.blocks.woodbasin.WoodenBasinBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class WoodenBasinBlock
extends Block
implements EntityBlock {
    private static final VoxelShape INSIDE = WoodenBasinBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)WoodenBasinBlock.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{WoodenBasinBlock.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), WoodenBasinBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.ONLY_FIRST);

    public WoodenBasinBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.0f));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return INSIDE;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new WoodenBasinBlockEntity(blockPos, blockState);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        WoodenBasinBlockEntity basin;
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof WoodenBasinBlockEntity && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)(basin = (WoodenBasinBlockEntity)blockEntity).getFluidHandler())) {
            return ItemInteractionResult.CONSUME;
        }
        return stack.getCapability(Capabilities.FluidHandler.ITEM) == null ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.SUCCESS;
    }

    @EventBusSubscriber(modid="ftbstuff")
    public static class Listener {
        @SubscribeEvent
        public static void onEntityFall(LivingFallEvent event) {
            if (!event.getEntity().level().isClientSide) {
                BlockEntity blockEntity;
                BlockPos pos = event.getEntity().getOnPos();
                if ((double)event.getDistance() > 0.5 && (blockEntity = event.getEntity().level().getBlockEntity(pos.below())) instanceof WoodenBasinBlockEntity) {
                    WoodenBasinBlockEntity basin = (WoodenBasinBlockEntity)blockEntity;
                    basin.trySqueezing((Entity)event.getEntity());
                }
            }
        }
    }
}

