/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbstuffnthings.crafting.NoInventory;
import dev.ftb.mods.ftbstuffnthings.integration.stages.StageHelper;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import dev.ftb.mods.ftbstuffnthings.temperature.Temperature;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public class JarRecipe
implements Recipe<NoInventory>,
Comparable<JarRecipe> {
    private final Temperature temperature;
    private final int time;
    private final List<SizedIngredient> inputItems;
    private final List<SizedFluidIngredient> inputFluids;
    private final List<ItemStack> outputItems;
    private final List<FluidStack> outputFluids;
    private final boolean canRepeat;
    private final String stage;
    private final Lazy<String> filterText = Lazy.of(this::buildFilterText);

    public JarRecipe(List<SizedIngredient> inputItems, List<SizedFluidIngredient> inputFluids, List<ItemStack> outputItems, List<FluidStack> outputFluids, Temperature temperature, int time, boolean canRepeat, String stage) {
        this.inputItems = inputItems;
        this.inputFluids = inputFluids;
        this.outputItems = outputItems;
        this.outputFluids = outputFluids;
        this.temperature = temperature;
        this.time = time;
        this.canRepeat = canRepeat;
        this.stage = stage;
    }

    public boolean matches(NoInventory inv, Level world) {
        return true;
    }

    public ItemStack assemble(NoInventory noInventory, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipesRegistry.TEMPERED_JAR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return RecipesRegistry.TEMPERED_JAR_TYPE.get();
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public int getTime() {
        return this.time;
    }

    public List<SizedIngredient> getInputItems() {
        return this.inputItems;
    }

    public List<SizedFluidIngredient> getInputFluids() {
        return this.inputFluids;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public List<FluidStack> getOutputFluids() {
        return this.outputFluids;
    }

    public boolean canRepeat() {
        return this.canRepeat;
    }

    public String getStage() {
        return this.stage;
    }

    public boolean isAvailableFor(Player player) {
        return this.stage.isEmpty() || StageHelper.hasStage(player, this.stage);
    }

    public boolean hasItems() {
        return !this.inputItems.isEmpty() || !this.outputItems.isEmpty();
    }

    public boolean hasFluids() {
        return !this.inputFluids.isEmpty() || !this.outputFluids.isEmpty();
    }

    private int getTempOrder() {
        return this.temperature.ordinal();
    }

    public String getFilterText() {
        return (String)this.filterText.get();
    }

    private String buildFilterText() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (ItemStack itemStack : this.outputItems) {
            set.add(itemStack.getHoverName().getString().trim().toLowerCase());
        }
        for (FluidStack fluidStack : this.outputFluids) {
            set.add(fluidStack.getHoverName().getString().trim().toLowerCase());
        }
        for (SizedIngredient sizedIngredient : this.inputItems) {
            for (ItemStack itemStack : sizedIngredient.ingredient().getItems()) {
                set.add(itemStack.getHoverName().getString().trim().toLowerCase());
            }
        }
        for (SizedFluidIngredient sizedFluidIngredient : this.inputFluids) {
            for (ItemStack itemStack : sizedFluidIngredient.ingredient().getStacks()) {
                set.add(itemStack.getHoverName().getString().trim().toLowerCase());
            }
        }
        return String.join((CharSequence)" ", set);
    }

    public List<Either<SizedFluidIngredient, SizedIngredient>> allInputs() {
        ArrayList<Either<SizedFluidIngredient, SizedIngredient>> res = new ArrayList<Either<SizedFluidIngredient, SizedIngredient>>();
        this.inputFluids.forEach(f -> res.add(Either.left((Object)f)));
        this.inputItems.forEach(i -> res.add(Either.right((Object)i)));
        return res;
    }

    public boolean test(Temperature jarTemperature, IItemHandler jarItems, IFluidHandler jarFluids, boolean checkAmounts) {
        ItemStack toTest;
        int i;
        if (jarTemperature != this.getTemperature()) {
            return false;
        }
        int matched = 0;
        block0: for (SizedIngredient inputItem : this.inputItems) {
            for (i = 0; i < jarItems.getSlots(); ++i) {
                toTest = jarItems.getStackInSlot(i);
                if (!(checkAmounts ? inputItem.test(toTest) : inputItem.ingredient().test(toTest))) continue;
                ++matched;
                continue block0;
            }
        }
        if (matched != this.inputItems.size()) {
            return false;
        }
        matched = 0;
        block2: for (SizedFluidIngredient inputFluid : this.inputFluids) {
            for (i = 0; i < jarFluids.getTanks(); ++i) {
                toTest = jarFluids.getFluidInTank(i);
                if (!(checkAmounts ? inputFluid.test((FluidStack)toTest) : inputFluid.ingredient().test((FluidStack)toTest))) continue;
                ++matched;
                continue block2;
            }
        }
        return matched == this.inputFluids.size();
    }

    public int inputIngredientCount() {
        return this.inputFluids.size() + this.inputItems.size();
    }

    @Override
    public int compareTo(@NotNull JarRecipe o) {
        int c = this.getTemperature().compareTo(o.getTemperature());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(o.inputIngredientCount(), this.inputIngredientCount());
        if (c != 0) {
            return c;
        }
        c = Integer.compare(o.getInputItems().stream().mapToInt(SizedIngredient::count).sum(), this.getInputItems().stream().mapToInt(SizedIngredient::count).sum());
        if (c != 0) {
            return c;
        }
        return Integer.compare(o.getInputFluids().stream().mapToInt(SizedFluidIngredient::amount).sum(), this.getInputFluids().stream().mapToInt(SizedFluidIngredient::amount).sum());
    }

    public static class Serializer<T extends JarRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SizedIngredient.FLAT_CODEC.listOf(0, 3).optionalFieldOf("input_items", List.of()).forGetter(JarRecipe::getInputItems), (App)SizedFluidIngredient.FLAT_CODEC.listOf(0, 3).optionalFieldOf("input_fluids", List.of()).forGetter(JarRecipe::getInputFluids), (App)ItemStack.CODEC.listOf(0, 3).optionalFieldOf("output_items", List.of()).forGetter(JarRecipe::getOutputItems), (App)FluidStack.CODEC.listOf(0, 3).optionalFieldOf("output_fluids", List.of()).forGetter(JarRecipe::getOutputFluids), (App)StringRepresentable.fromEnum(Temperature::values).optionalFieldOf("temperature", (Object)Temperature.NORMAL).forGetter(JarRecipe::getTemperature), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("time", (Object)200).forGetter(JarRecipe::getTime), (App)Codec.BOOL.optionalFieldOf("can_repeat", (Object)true).forGetter(JarRecipe::canRepeat), (App)Codec.STRING.optionalFieldOf("stage", (Object)"").forGetter(JarRecipe::getStage)).apply((Applicative)builder, factory::create)).validate(Serializer::validateRecipe);
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = NetworkHelper.composite((StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), JarRecipe::getInputItems, (StreamCodec)SizedFluidIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), JarRecipe::getInputFluids, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), JarRecipe::getOutputItems, (StreamCodec)FluidStack.STREAM_CODEC.apply(ByteBufCodecs.list()), JarRecipe::getOutputFluids, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Temperature.class), JarRecipe::getTemperature, (StreamCodec)ByteBufCodecs.VAR_INT, JarRecipe::getTime, (StreamCodec)ByteBufCodecs.BOOL, JarRecipe::canRepeat, (StreamCodec)ByteBufCodecs.STRING_UTF8, JarRecipe::getStage, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        @NotNull
        private static <T extends JarRecipe> DataResult<T> validateRecipe(T recipe) {
            if (recipe.getInputItems().isEmpty() && recipe.getInputFluids().isEmpty()) {
                return DataResult.error(() -> "at least one of input_items & input_fluids must be non-empty!");
            }
            if (recipe.getOutputItems().isEmpty() && recipe.getOutputFluids().isEmpty()) {
                return DataResult.error(() -> "at least one of output_items & output_fluids must be non-empty!");
            }
            if (recipe.inputIngredientCount() > 3) {
                return DataResult.error(() -> "must be 1-3 item & fluid inputs combined!");
            }
            if (recipe.getOutputItems().size() + recipe.getOutputFluids().size() > 3) {
                return DataResult.error(() -> "must be 1-3 item & fluid outputs combined!");
            }
            return DataResult.success(recipe);
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends JarRecipe> {
        public T create(List<SizedIngredient> var1, List<SizedFluidIngredient> var2, List<ItemStack> var3, List<FluidStack> var4, Temperature var5, int var6, boolean var7, String var8);
    }
}

