/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbstuffnthings.crafting.BaseRecipe;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.registry.RecipesRegistry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class SluiceRecipe
extends BaseRecipe<SluiceRecipe> {
    private final Ingredient ingredient;
    private final List<ItemWithChance> results;
    private final int maxResults;
    private final Optional<SizedFluidIngredient> fluid;
    private final float processingTimeMultiplier;
    private final Set<MeshType> meshTypes;

    public SluiceRecipe(Ingredient ingredient, List<ItemWithChance> results, int maxResults, Optional<SizedFluidIngredient> fluid, float processingTimeMultiplier, List<MeshType> meshTypes) {
        super(RecipesRegistry.SLUICE_SERIALIZER, RecipesRegistry.SLUICE_TYPE);
        this.ingredient = ingredient;
        this.results = results;
        this.maxResults = maxResults;
        this.fluid = fluid;
        this.processingTimeMultiplier = processingTimeMultiplier;
        this.meshTypes = EnumSet.copyOf(meshTypes);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemWithChance> getResults() {
        return this.results;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Optional<SizedFluidIngredient> getFluid() {
        return this.fluid;
    }

    public boolean testFluid(FluidStack toCheck, boolean checkAmount, double fluidModifier) {
        return this.fluid.map(ingr -> checkAmount ? ingr.test(toCheck.copyWithAmount((int)((double)toCheck.getAmount() / fluidModifier))) : ingr.ingredient().test(toCheck)).orElse(true);
    }

    public boolean testFluid(FluidStack toCheck, boolean checkAmount) {
        return this.testFluid(toCheck, checkAmount, 1.0);
    }

    public float getProcessingTimeMultiplier() {
        return this.processingTimeMultiplier;
    }

    public Set<MeshType> getMeshTypes() {
        return Collections.unmodifiableSet(this.meshTypes);
    }

    public List<MeshType> getMeshTypesAsList() {
        return List.copyOf(this.meshTypes);
    }

    public static class Serializer<T extends SluiceRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(SluiceRecipe::getIngredient), (App)ItemWithChance.CODEC.listOf().fieldOf("results").forGetter(SluiceRecipe::getResults), (App)Codec.INT.optionalFieldOf("max_results", (Object)4).forGetter(SluiceRecipe::getMaxResults), (App)SizedFluidIngredient.FLAT_CODEC.optionalFieldOf("fluid").forGetter(SluiceRecipe::getFluid), (App)Codec.FLOAT.optionalFieldOf("processing_time_multiplier", (Object)Float.valueOf(1.0f)).forGetter(SluiceRecipe::getProcessingTimeMultiplier), (App)MeshType.CODEC.listOf().fieldOf("mesh_types").forGetter(SluiceRecipe::getMeshTypesAsList)).apply((Applicative)builder, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SluiceRecipe::getIngredient, (StreamCodec)ItemWithChance.STREAM_CODEC.apply(ByteBufCodecs.list()), SluiceRecipe::getResults, (StreamCodec)ByteBufCodecs.VAR_INT, SluiceRecipe::getMaxResults, (StreamCodec)ByteBufCodecs.optional((StreamCodec)SizedFluidIngredient.STREAM_CODEC), SluiceRecipe::getFluid, (StreamCodec)ByteBufCodecs.FLOAT, SluiceRecipe::getProcessingTimeMultiplier, (StreamCodec)MeshType.STREAM_CODEC.apply(ByteBufCodecs.list()), SluiceRecipe::getMeshTypesAsList, factory::create);

        public Serializer(IFactory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    public static interface IFactory<T extends SluiceRecipe> {
        public T create(Ingredient var1, List<ItemWithChance> var2, int var3, Optional<SizedFluidIngredient> var4, float var5, List<MeshType> var6);
    }
}

