/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockModelsGenerator
extends BlockModelProvider {
    public BlockModelsGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ftbstuff", existingFileHelper);
    }

    private ResourceLocation getLoc(String loc) {
        return ResourceLocation.fromNamespaceAndPath((String)"ftbstuff", (String)("block/" + loc));
    }

    private ResourceLocation getMCLoc(String loc) {
        return ResourceLocation.withDefaultNamespace((String)("block/" + loc));
    }

    protected void registerModels() {
        this.makeSluice("oak");
        this.makeSluice("spruce");
        this.makeSluice("birch");
        this.makeSluice("jungle");
        this.makeSluice("acacia");
        this.makeSluice("dark_oak");
        this.makeSluice("mangrove");
        this.makeSluice("cherry");
        this.makeSluice("pale_oak");
        this.makeSluice("crimson");
        this.makeSluice("warped");
        this.makeSluice("bamboo");
        this.makeSluice("iron");
        this.makeSluice("diamond");
        this.makeSluice("netherite");
        this.makeGenerator("cobblestone");
        this.makeGenerator("basalt");
        this.makeHammer();
        this.makeMesh();
    }

    private void makeSluice(String type) {
        this.singleTexture("block/" + type + "_sluice_body", this.getLoc("sluice_body"), "0", this.getLoc("sluice/" + type + "_sluice"));
        this.singleTexture("block/" + type + "_sluice_front", this.getLoc("sluice_front"), "0", this.getLoc("sluice/" + type + "_sluice"));
    }

    private void makeGenerator(String type) {
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/stone_" + type + "_generator", this.getLoc(type + "_generator"))).texture("0", this.getLoc("generator/stone"))).texture("particle", this.getMCLoc("cobblestone"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/iron_" + type + "_generator", this.getLoc(type + "_generator"))).texture("0", this.getLoc("generator/iron"))).texture("particle", this.getMCLoc("iron_block"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/gold_" + type + "_generator", this.getLoc(type + "_generator"))).texture("0", this.getLoc("generator/gold"))).texture("particle", this.getMCLoc("gold_block"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/diamond_" + type + "_generator", this.getLoc(type + "_generator"))).texture("0", this.getLoc("generator/diamond"))).texture("particle", this.getMCLoc("diamond_block"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/netherite_" + type + "_generator", this.getLoc(type + "_generator"))).texture("0", this.getLoc("generator/netherite"))).texture("particle", this.getMCLoc("netherite_block"));
    }

    private void makeHammer() {
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/iron_auto_hammer", this.getLoc("auto_hammer"))).texture("base", this.getLoc("auto_hammer/iron_base"))).texture("hammer", this.getLoc("auto_hammer/iron_hammer"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/gold_auto_hammer", this.getLoc("auto_hammer"))).texture("base", this.getLoc("auto_hammer/gold_base"))).texture("hammer", this.getLoc("auto_hammer/gold_hammer"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/diamond_auto_hammer", this.getLoc("auto_hammer"))).texture("base", this.getLoc("auto_hammer/diamond_base"))).texture("hammer", this.getLoc("auto_hammer/diamond_hammer"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/netherite_auto_hammer", this.getLoc("auto_hammer"))).texture("base", this.getLoc("auto_hammer/netherite_base"))).texture("hammer", this.getLoc("auto_hammer/netherite_hammer"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/iron_auto_hammer_active", this.getLoc("auto_hammer_active"))).texture("base", this.getLoc("auto_hammer/iron_base"))).texture("hammer", this.getLoc("auto_hammer/iron_hammer_active"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/gold_auto_hammer_active", this.getLoc("auto_hammer_active"))).texture("base", this.getLoc("auto_hammer/gold_base"))).texture("hammer", this.getLoc("auto_hammer/gold_hammer_active"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/diamond_auto_hammer_active", this.getLoc("auto_hammer_active"))).texture("base", this.getLoc("auto_hammer/diamond_base"))).texture("hammer", this.getLoc("auto_hammer/diamond_hammer_active"));
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("block/netherite_auto_hammer_active", this.getLoc("auto_hammer_active"))).texture("base", this.getLoc("auto_hammer/netherite_base"))).texture("hammer", this.getLoc("auto_hammer/netherite_hammer_active"));
    }

    private void makeMesh() {
        this.singleTexture("block/cloth_mesh", this.getLoc("mesh"), "0", this.getLoc("mesh/cloth"));
        this.singleTexture("block/iron_mesh", this.getLoc("mesh"), "0", this.getLoc("mesh/iron"));
        this.singleTexture("block/gold_mesh", this.getLoc("mesh"), "0", this.getLoc("mesh/gold"));
        this.singleTexture("block/diamond_mesh", this.getLoc("mesh"), "0", this.getLoc("mesh/diamond"));
        this.singleTexture("block/blazing_mesh", this.getLoc("mesh"), "0", this.getLoc("mesh/blazing"));
    }
}

