/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.data;

import dev.ftb.mods.ftbstuffnthings.FTBStuffTags;
import dev.ftb.mods.ftbstuffnthings.items.MeshType;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class BlockTagsGenerator
extends BlockTagsProvider {
    private static final Pattern SHOVEL_BLOCKS = Pattern.compile("(clay|dirt|dust|gravel|sand|soil)");

    public BlockTagsGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "ftbstuff", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(FTBStuffTags.Blocks.MINEABLE_WITH_HAMMER).addTags(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.MINEABLE_WITH_SHOVEL});
        BlocksRegistry.BLOCKS.getEntries().forEach(entry -> {
            Block block = (Block)entry.get();
            String path = entry.getId().getPath();
            if (path.startsWith("compressed_")) {
                TagKey toolTag = SHOVEL_BLOCKS.matcher(path).find() ? BlockTags.MINEABLE_WITH_SHOVEL : BlockTags.MINEABLE_WITH_PICKAXE;
                this.tag(toolTag).add((Object)block);
                this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)block);
            } else if (!(block instanceof LiquidBlock) && !(block instanceof AirBlock)) {
                this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)block);
                this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)block);
            }
        });
        BlocksRegistry.ALL_SLUICES.forEach(sluice -> this.tag(FTBStuffTags.Blocks.SLUICE).add((Object)((Block)sluice.get())));
        BlocksRegistry.WOODEN_SLUICE.forEach(sluice -> this.tag(FTBStuffTags.Blocks.WOODEN_SLUICES).add((Object)((Block)sluice.get())));
        BlocksRegistry.CRATES.forEach(crate -> this.tag(FTBStuffTags.Blocks.CRATE).add((Object)((Block)crate.get())));
        BlocksRegistry.BARRELS.forEach(barrel -> this.tag(FTBStuffTags.Blocks.BARREL).add((Object)((Block)barrel.get())));
        BlocksRegistry.waterStrainers().forEach(strainer -> this.tag(FTBStuffTags.Blocks.WATER_STRAINER).add((Object)((Block)strainer.get())));
        MeshType.NON_EMPTY_VALUES.forEach(mesh -> {
            if (mesh == MeshType.BLAZING) {
                this.tag(FTBStuffTags.Blocks.allowedMeshes(mesh)).add((Object)((Block)BlocksRegistry.NETHERITE_SLUICE.get()));
            } else {
                this.tag(FTBStuffTags.Blocks.allowedMeshes(mesh)).addTag(FTBStuffTags.Blocks.SLUICE);
            }
        });
    }
}

