/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftbstuffnthings.crafting.ItemWithChance;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.CrookRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CrookCategory
extends BaseStuffCategory<CrookRecipe> {
    private static final Comparator<ItemWithChance> COMPARATOR = (a, b) -> (int)(b.chance() * 100.0 - a.chance() * 100.0);

    public CrookCategory() {
        super(RecipeTypes.CROOK, (Component)Component.translatable((String)"item.ftbstuff.stone_crook"), (IDrawable)CrookCategory.guiHelper().drawableBuilder(CrookCategory.bgTexture("jei_crook.png"), 0, 0, 156, 78).setTextureSize(180, 78).build(), CrookCategory.guiHelper().createDrawableItemStack(ItemsRegistry.CROOK.toStack()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrookRecipe crookRecipe, IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addIngredients(crookRecipe.getIngredient())).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            if (crookRecipe.getResults().size() > 1 && crookRecipe.getMax() > 0) {
                tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.crook.limit", (Object[])new Object[]{crookRecipe.getMax()}));
            }
        });
        List<ItemWithChance> outputs = crookRecipe.getResults().stream().sorted(COMPARATOR).toList();
        for (int i = 0; i < outputs.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 28 + i % 7 * 18, 5 + i / 7 * 24).addItemStack(outputs.get(i).item());
        }
    }

    @Override
    public void draw(CrookRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, graphics, mouseX, mouseY);
        List<ItemWithChance> outputs = recipe.getResults().stream().sorted(COMPARATOR).toList();
        int row = 0;
        for (int i = 0; i < outputs.size(); ++i) {
            if (i > 0 && i % 7 == 0) {
                ++row;
            }
            PoseStack stack = graphics.pose();
            stack.pushPose();
            stack.translate((float)(36 + i % 7 * 18), 23.5f + (float)(row * 24), 100.0f);
            stack.scale(0.5f, 0.5f, 8000.0f);
            graphics.drawCenteredString(Minecraft.getInstance().font, Math.round(outputs.get(i).chance() * 100.0) + "%", 0, 0, 0xFFFFFF);
            stack.popPose();
        }
    }
}

