/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.integration.jei;

import dev.ftb.mods.ftbstuffnthings.blocks.woodbasin.WoodenBasinBlock;
import dev.ftb.mods.ftbstuffnthings.crafting.recipe.WoodenBasinRecipe;
import dev.ftb.mods.ftbstuffnthings.integration.jei.BaseStuffCategory;
import dev.ftb.mods.ftbstuffnthings.integration.jei.FluidAmountDrawable;
import dev.ftb.mods.ftbstuffnthings.integration.jei.RecipeTypes;
import dev.ftb.mods.ftbstuffnthings.registry.BlocksRegistry;
import dev.ftb.mods.ftbstuffnthings.registry.ItemsRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class WoodenBasinCategory
extends BaseStuffCategory<WoodenBasinRecipe> {
    protected WoodenBasinCategory() {
        super(RecipeTypes.WOODEN_BASIN, (Component)Component.translatable((String)((WoodenBasinBlock)((Object)BlocksRegistry.WOODEN_BASIN.get())).getDescriptionId()), (IDrawable)WoodenBasinCategory.guiHelper().drawableBuilder(WoodenBasinCategory.bgTexture("jei_wooden_basin.png"), 0, 0, 64, 64).setTextureSize(64, 64).build(), WoodenBasinCategory.guiHelper().createDrawableItemStack(new ItemStack((ItemLike)ItemsRegistry.WOODEN_BASIN.get())));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WoodenBasinRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputBuilder = builder.addInputSlot(6, 25);
        recipe.getInputsForDisplay().forEach(input -> input.ifLeft(stack -> inputBuilder.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, stack)).ifRight(fluid -> inputBuilder.addFluidStack(fluid, 1000L)));
        builder.addOutputSlot(43, 43).addFluidStack(recipe.getFluid().getFluid(), (long)recipe.getFluid().getAmount()).setOverlay((IDrawable)new FluidAmountDrawable(recipe.getFluid().getAmount()), 0, 0);
    }

    @Override
    public void draw(WoodenBasinRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        guiGraphics.renderItem(ItemsRegistry.WOODEN_BASIN.toStack(), 6, 43);
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"ftblibrary", (String)"textures/icons/info.png"), 42, 5, 0, 0.0f, 16.0f, 16, 16, 16, 16);
    }

    public void getTooltip(ITooltipBuilder tooltip, WoodenBasinRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 41.0 && mouseX <= 59.0 && mouseY >= 4.0 && mouseY <= 22.0) {
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.jei.wooden_basin_info"));
            tooltip.add((FormattedText)Component.empty());
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.wooden_basin.produce_chance", (Object[])new Object[]{(int)(recipe.getProductionChance() * 100.0f)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((FormattedText)Component.translatable((String)"ftbstuff.wooden_basin.consume_chance", (Object[])new Object[]{(int)(recipe.getBlockConsumeChance() * 100.0f)}).withStyle(ChatFormatting.GRAY));
        }
    }
}

