/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbstuffnthings.util.lootsummary;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;

public class LootSummary {
    public static final StreamCodec<RegistryFriendlyByteBuf, LootSummary> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(LinkedHashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, SummaryEntry.LIST_STREAM_CODEC), LootSummary::entryMap, LootSummary::new);
    private final Map<String, List<SummaryEntry>> entryMap;
    private final int hashCode;

    private LootSummary(Map<String, List<SummaryEntry>> entryMap) {
        this.entryMap = Collections.unmodifiableMap(entryMap);
        this.hashCode = entryMap.hashCode();
    }

    public static LootSummary forLootTable(LootTable table, LootParams params) {
        LinkedHashMap<String, List<SummaryEntry>> map = new LinkedHashMap<String, List<SummaryEntry>>();
        LootContext ctx = new LootContext.Builder(params).create(Optional.empty());
        LootSummary.expandTable(table, ctx, map, 1.0f);
        LinkedHashMap<String, List<SummaryEntry>> sortedMap = new LinkedHashMap<String, List<SummaryEntry>>();
        map.forEach((pool, entries) -> sortedMap.put((String)pool, entries.stream().sorted().toList()));
        return new LootSummary(sortedMap);
    }

    private static void expandTable(LootTable table, LootContext ctx, Map<String, List<SummaryEntry>> map, float weightMult) {
        for (LootPool pool : table.pools) {
            ImmutableList.Builder builder = ImmutableList.builder();
            MutableFloat totalWeight = new MutableFloat(0.0f);
            for (LootPoolEntryContainer entryContainer : pool.entries) {
                if (entryContainer instanceof LootPoolSingletonContainer) {
                    LootPoolSingletonContainer s = (LootPoolSingletonContainer)entryContainer;
                    totalWeight.add((float)s.weight);
                    continue;
                }
                entryContainer.expand(ctx, entry -> totalWeight.add((float)entry.getWeight(1.0f)));
            }
            for (LootPoolEntryContainer entryContainer : pool.entries) {
                if (entryContainer instanceof NestedLootTable) {
                    NestedLootTable nested = (NestedLootTable)entryContainer;
                    LootSummary.expandTable(LootSummary.getNestedLootTable(nested, ctx), ctx, map, weightMult * (float)nested.weight / totalWeight.floatValue());
                    continue;
                }
                entryContainer.expand(ctx, entry -> entry.createItemStack(stack -> builder.add((Object)new SummaryEntry(weightMult * (float)entry.getWeight(1.0f) / totalWeight.floatValue(), (ItemStack)stack)), ctx));
            }
            String tblName = Objects.requireNonNullElse(pool.getName(), String.format("pool:%X", pool.hashCode()));
            map.computeIfAbsent(tblName, k -> new ArrayList()).addAll(builder.build());
        }
    }

    private static LootTable getNestedLootTable(NestedLootTable nested, LootContext ctx) {
        return (LootTable)nested.contents.map(resourceKey -> ctx.getResolver().get(Registries.LOOT_TABLE, resourceKey).map(Holder::value).orElse(LootTable.EMPTY), table -> table);
    }

    public Map<String, List<SummaryEntry>> entryMap() {
        return this.entryMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LootSummary that = (LootSummary)o;
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public record SummaryEntry(float weight, ItemStack stack) implements Comparable<SummaryEntry>
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, SummaryEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, SummaryEntry::weight, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SummaryEntry::stack, SummaryEntry::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<SummaryEntry>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SummaryEntry that = (SummaryEntry)o;
            return this.weight == that.weight && ItemStack.matches((ItemStack)this.stack, (ItemStack)that.stack);
        }

        @Override
        public int hashCode() {
            return Objects.hash(Float.valueOf(this.weight), ItemStack.hashItemAndComponents((ItemStack)this.stack), this.stack.getCount());
        }

        @Override
        public int compareTo(@NotNull SummaryEntry o) {
            return Float.compare(o.weight, this.weight);
        }
    }
}

