/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.client.gui;

import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionManager;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BaseSelectionScreen
extends Screen {
    private final Consumer<ResourceLocation> onSelect;
    private StartList startList;
    private Button createButton;
    private AbstractTexture fallbackIcon;
    static final int UPPER_HEIGHT = 80;
    static final int LOWER_HEIGHT = 40;

    public BaseSelectionScreen(Consumer<ResourceLocation> onSelect) {
        super((Component)Component.empty());
        this.onSelect = onSelect;
    }

    protected void init() {
        super.init();
        this.startList = new StartList(this.minecraft, this.width, this.height - 80 - 40, 80);
        EditBox searchBox = new EditBox(this.font, this.width / 2 - 80, 40, 160, 20, (Component)Component.empty());
        searchBox.setResponder(this.startList::addChildren);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), btn -> this.onClose()).size(100, 20).pos(this.width / 2 - 130, this.height - 30).build());
        this.createButton = Button.builder((Component)Component.translatable((String)"ftbteambases.gui.create"), btn -> this.doCreate()).size(150, 20).pos(this.width / 2 - 20, this.height - 30).build();
        this.addRenderableWidget((GuiEventListener)this.createButton);
        this.createButton.active = false;
        this.addRenderableWidget((GuiEventListener)searchBox);
        this.addRenderableWidget((GuiEventListener)this.startList);
        this.fallbackIcon = this.minecraft.getTextureManager().getTexture(BaseDefinition.FALLBACK_IMAGE);
    }

    private void doCreate() {
        if (this.startList.getSelected() != null) {
            this.onSelect.accept(((StartList.Entry)this.startList.getSelected()).baseDef.id());
            if (this.minecraft.level != null) {
                this.onClose();
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        String value = Component.translatable((String)"ftbteambases.gui.select_start").getString();
        graphics.drawString(this.font, value, (this.width - this.font.width(value)) / 2, 20, 0xFFFFFF);
    }

    private class StartList
    extends AbstractSelectionList<Entry> {
        StartList(Minecraft minecraft, int width, int height, int top) {
            super(minecraft, width, height, top, 50);
            this.addChildren("");
        }

        public int getRowWidth() {
            return 340;
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 170;
        }

        public void setSelected(@Nullable Entry entry) {
            BaseSelectionScreen.this.createButton.active = entry != null;
            super.setSelected((AbstractSelectionList.Entry)entry);
        }

        private void addChildren(String filterStr) {
            this.children().clear();
            this.children().addAll(BaseDefinitionManager.getClientInstance().getDefinitions().stream().filter(baseDef -> baseDef.matchesName(filterStr) && baseDef.shouldShowInGui()).sorted(Comparator.comparingInt(BaseDefinition::displayOrder).thenComparing(BaseDefinition::description)).map(x$0 -> new Entry((BaseDefinition)x$0)).toList());
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private class Entry
        extends AbstractSelectionList.Entry<Entry> {
            private final BaseDefinition baseDef;
            private long lastClickTime;

            private Entry(BaseDefinition baseDef) {
                this.baseDef = baseDef;
            }

            public boolean mouseClicked(double x, double y, int partialTick) {
                StartList.this.setSelected(this);
                if (Util.getMillis() - this.lastClickTime < 250L) {
                    BaseSelectionScreen.this.onClose();
                    BaseSelectionScreen.this.onSelect.accept(this.baseDef.id());
                    return true;
                }
                this.lastClickTime = Util.getMillis();
                return false;
            }

            public void render(GuiGraphics graphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean bl, float partialTicks) {
                Font font = Minecraft.getInstance().font;
                int startX = left + 80;
                graphics.drawString(font, (Component)Component.translatable((String)this.baseDef.description()), startX, top + 10, 0xFFFFFF);
                graphics.drawString(font, (Component)Component.translatable((String)"ftbteambases.gui.by", (Object[])new Object[]{this.baseDef.author()}), startX, top + 26, 0xD3D3D3);
                ResourceLocation preview = this.baseDef.previewImage();
                graphics.blit(preview, left + 7, top + 7, 0.0f, 0.0f, 56, 32, 56, 32);
            }
        }
    }
}

