/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.purging;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.bases.ArchivedBaseDetails;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.purging.PendingPurgeData;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public enum PurgeManager {
    INSTANCE;

    private PendingPurgeData data;
    private MinecraftServer server;
    private final List<String> purgedArchiveIds = new ArrayList<String>();

    private PendingPurgeData getData(MinecraftServer server) {
        if (this.data == null) {
            this.data = PendingPurgeData.readFromFile(server);
            this.server = server;
        }
        return this.data;
    }

    public void init(MinecraftServer server) {
        this.server = server;
        this.checkForPurges(server);
    }

    public void onShutdown() {
        this.data = null;
        this.server = null;
    }

    public boolean clearPending() {
        return this.getData(this.server).clearPending().writeToFile(this.server);
    }

    public void checkForPurges(MinecraftServer server) {
        this.purgedArchiveIds.clear();
        ArrayList<ResourceLocation> purgedDims = new ArrayList<ResourceLocation>();
        this.getData(this.server).pending().forEach((id, purgeRecord) -> {
            purgeRecord.doPurge(this.server, false);
            this.purgedArchiveIds.add((String)id);
            if (DimensionUtils.isPrivateTeamDimension(purgeRecord.dimensionId())) {
                purgedDims.add(purgeRecord.dimensionId());
            }
        });
        if (!purgedDims.isEmpty()) {
            PurgeManager.removeLevelsFromLevelDat(server, purgedDims);
        }
        this.clearPending();
    }

    public boolean addPending(Collection<ArchivedBaseDetails> details) {
        return this.getData(this.server).add(details).writeToFile(this.server);
    }

    public boolean removePending(Collection<ArchivedBaseDetails> details) {
        return this.getData(this.server).remove(details).writeToFile(this.server);
    }

    public boolean removePending(String id) throws CommandSyntaxException {
        if (!this.getData(this.server).pending().containsKey(id)) {
            throw CommandUtils.PURGE_NOT_FOUND.create((Object)id);
        }
        return this.getData(this.server).remove(id).writeToFile(this.server);
    }

    public Collection<String> getPendingIds() {
        return this.getData(this.server).pending().keySet();
    }

    public void cleanUpPurgedArchives(BaseInstanceManager res) {
        if (!this.purgedArchiveIds.isEmpty()) {
            this.purgedArchiveIds.forEach(res::removeArchivedBase);
            this.purgedArchiveIds.clear();
        }
    }

    private static void removeLevelsFromLevelDat(MinecraftServer server, List<ResourceLocation> ids) {
        Path levelDatFile = server.getWorldPath(LevelResource.LEVEL_DATA_FILE);
        try {
            CompoundTag tag = NbtIo.readCompressed((Path)levelDatFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
            CompoundTag tag1 = tag.getCompound("Data").getCompound("WorldGenSettings").getCompound("dimensions");
            ids.forEach(id -> tag1.remove(id.toString()));
            File tempFile = File.createTempFile("tmp-level", ".dat", levelDatFile.toFile());
            NbtIo.writeCompressed((CompoundTag)tag, (Path)tempFile.toPath());
            File backupFile = server.getServerDirectory().resolve("level.dat.old").toFile();
            Util.safeReplaceFile((Path)levelDatFile, (Path)tempFile.toPath(), (Path)backupFile.toPath());
            FTBTeamBases.LOGGER.info("removed {} purged base dimension(s) from level.dat", (Object)ids.size());
        }
        catch (IOException e) {
            FTBTeamBases.LOGGER.error("can't update level.dat to remove purged ids: {} / {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }
}

