/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.registry;

import com.mojang.serialization.MapCodec;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.ChunkGenerators;
import dev.ftb.mods.ftbteambases.worldgen.placement.OneChunkOnlyPlacement;
import dev.ftb.mods.ftbteambases.worldgen.processor.WaterLoggingFixProcessor;
import dev.ftb.mods.ftbteambases.worldgen.structure.StartStructure;
import dev.ftb.mods.ftbteambases.worldgen.structure.StartStructurePiece;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModWorldGen {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"ftbteambases");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"ftbteambases");
    public static final DeferredRegister<StructurePlacementType<?>> STRUCTURE_PLACEMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PLACEMENT, (String)"ftbteambases");
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PROCESSOR, (String)"ftbteambases");
    public static final DeferredRegister<MapCodec<? extends ChunkGenerator>> CHUNK_GENERATORS = DeferredRegister.create((ResourceKey)Registries.CHUNK_GENERATOR, (String)"ftbteambases");
    public static final Supplier<StructureType<StartStructure>> START_STRUCTURE = STRUCTURE_TYPES.register("start", () -> ModWorldGen.explicitStructureTypeTyping(StartStructure.CODEC));
    public static final Supplier<StructurePieceType.StructureTemplateType> START_STRUCTURE_PIECE = STRUCTURE_PIECE_TYPES.register("start", () -> StartStructurePiece::new);
    public static final Supplier<StructurePlacementType<OneChunkOnlyPlacement>> ONE_CHUNK_ONLY_PLACEMENT = STRUCTURE_PLACEMENT_TYPES.register("one_chunk_only", () -> ModWorldGen.explicitStructurePlacementTypeTyping(OneChunkOnlyPlacement.CODEC));
    public static final Supplier<StructureProcessorType<WaterLoggingFixProcessor>> WATER_LOGGING_FIX_PROCESSOR = STRUCTURE_PROCESSORS.register("waterlogging_fix_processor", () -> () -> WaterLoggingFixProcessor.CODEC);

    private static <T extends Structure> StructureType<T> explicitStructureTypeTyping(MapCodec<T> codec) {
        return () -> codec;
    }

    private static <T extends StructurePlacement> StructurePlacementType<T> explicitStructurePlacementTypeTyping(MapCodec<T> codec) {
        return () -> codec;
    }

    public static void init(IEventBus eventBus) {
        STRUCTURE_TYPES.register(eventBus);
        STRUCTURE_PIECE_TYPES.register(eventBus);
        STRUCTURE_PLACEMENT_TYPES.register(eventBus);
        STRUCTURE_PROCESSORS.register(eventBus);
        CHUNK_GENERATORS.register(eventBus);
    }

    static {
        ChunkGenerators.register(CHUNK_GENERATORS);
    }
}

