/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.api.shape.Shape;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.crops.VanillaCropLikeHandler;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface BlockMatchers {
    public static final ShapeContext.Matcher MATCH_BY_BLOCK = BlockMatcher.wrap((original, state) -> original.getBlock() == state.getBlock());
    public static final ShapeContext.Matcher MATCH_BY_TAGS_SHAPELESS = BlockMatcher.wrap(FTBUltimineServerConfig.MERGE_TAGS_SHAPELESS::match);
    public static final ShapeContext.Matcher MATCH_BY_TAGS_SHAPED = BlockMatcher.wrap(FTBUltimineServerConfig.MERGE_TAGS_SHAPED::match);
    public static final ShapeContext.Matcher MATCH_BY_CROP_TYPE = BlockMatcher.wrap((original, state) -> VanillaCropLikeHandler.equivalentForSelection(original, state) || CropLikeRegistry.getInstance().areStatesEquivalent(original, state));

    public static ShapeContext.Matcher determineBestMatcher(Level level, BlockPos pos, BlockState origState, Shape shape) {
        ShapeContext.Matcher tagMatcher;
        ShapeContext.Matcher matcher = tagMatcher = shape.isIndeterminateShape() ? MATCH_BY_TAGS_SHAPELESS : MATCH_BY_TAGS_SHAPED;
        if (tagMatcher.check(origState, origState)) {
            return tagMatcher;
        }
        if (VanillaCropLikeHandler.looksLikeACrop(origState) || CropLikeRegistry.getInstance().getHandlerFor(level, pos, origState).isPresent()) {
            return MATCH_BY_CROP_TYPE;
        }
        return MATCH_BY_BLOCK;
    }
}

