/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.block;

import dev.ftb.mods.ftbunearthed.block.UneartherCoreBlockEntity;
import dev.ftb.mods.ftbunearthed.block.UneartherFrameBlock;
import dev.ftb.mods.ftbunearthed.block.UneartherFrameBlockEntity;
import dev.ftb.mods.ftbunearthed.registry.ModBlocks;
import dev.ftb.mods.ftbunearthed.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public class UneartherCoreBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = UneartherCoreBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public UneartherCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = (BlockState)this.getStateDefinition().any();
        state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        this.registerDefaultState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!this.validatePlaceableBlock(context)) {
            this.sendObstructedMessage(context.getPlayer(), "ftbunearthed.message.obstructed_block");
            return null;
        }
        if (!this.validatePlaceableEntity(context)) {
            this.sendObstructedMessage(context.getPlayer(), "ftbunearthed.message.obstructed_entity");
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    private void sendObstructedMessage(Player player, String msgKey) {
        if (player != null && !player.level().isClientSide()) {
            player.displayClientMessage((Component)Component.translatable((String)msgKey).withStyle(ChatFormatting.RED), true);
        }
    }

    private boolean validatePlaceableBlock(BlockPlaceContext ctx) {
        BoundingBox box = new BoundingBox(ctx.getClickedPos()).inflatedBy(1).moved(0, 1, 0);
        return BlockPos.betweenClosedStream((BoundingBox)box).allMatch(pos -> ctx.getLevel().getBlockState(pos).canBeReplaced(ctx));
    }

    private boolean validatePlaceableEntity(BlockPlaceContext ctx) {
        AABB box = new AABB(ctx.getClickedPos()).inflate(1.0).move(0.0, 1.0, 0.0);
        return ctx.getLevel().getEntities((Entity)null, box, e -> true).isEmpty();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof UneartherCoreBlockEntity) {
            UneartherCoreBlockEntity core = (UneartherCoreBlockEntity)blockEntity;
            BlockPos mid = pos.above();
            BlockPos top = mid.above();
            for (Direction d : MiscUtil.HORIZONTALS) {
                Direction d1 = d.getCounterClockWise();
                this.createFrameBlock(level, pos.relative(d), ModBlocks.L_EDGE, d, core);
                this.createFrameBlock(level, pos.relative(d).relative(d1), ModBlocks.L_CORNER, d, core);
                this.createFrameBlock(level, mid.relative(d), ModBlocks.M_FACE, d, core);
                this.createFrameBlock(level, mid.relative(d).relative(d1), ModBlocks.M_EDGE, d, core);
                this.createFrameBlock(level, top.relative(d), ModBlocks.U_EDGE, d, core);
                this.createFrameBlock(level, top.relative(d).relative(d1), ModBlocks.U_CORNER, d, core);
            }
            this.createFrameBlock(level, top, ModBlocks.U_FACE, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), core);
        }
    }

    private void createFrameBlock(Level level, BlockPos pos, DeferredBlock<UneartherFrameBlock> block, Direction rot, UneartherCoreBlockEntity core) {
        level.setBlock(pos, (BlockState)((UneartherFrameBlock)((Object)block.get())).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rot), 3);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof UneartherFrameBlockEntity) {
            UneartherFrameBlockEntity f = (UneartherFrameBlockEntity)blockEntity;
            f.setCore(core);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new UneartherCoreBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof UneartherCoreBlockEntity) {
                UneartherCoreBlockEntity machine = (UneartherCoreBlockEntity)blockEntity;
                machine.dropItemContents();
            }
            BoundingBox box = new BoundingBox(pos).inflatedBy(1).moved(0, 1, 0);
            BlockPos.betweenClosedStream((BoundingBox)box).forEach(p -> {
                if (level.getBlockState(p).getBlock() instanceof UneartherFrameBlock) {
                    level.destroyBlock(p, false);
                }
            });
        }
        super.onRemove(state, level, pos, newState, bl);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof UneartherCoreBlockEntity) {
            UneartherCoreBlockEntity be = (UneartherCoreBlockEntity)blockEntity;
            player.openMenu((MenuProvider)be, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof UneartherCoreBlockEntity) {
                UneartherCoreBlockEntity tickable = (UneartherCoreBlockEntity)t;
                if (level1 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level1;
                    tickable.tickServer(serverLevel);
                } else {
                    tickable.tickClient(level1);
                }
            }
        };
    }
}

