/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.block;

import dev.ftb.mods.ftbunearthed.block.UneartherFrameBlockEntity;
import dev.ftb.mods.ftbunearthed.util.VoxelShapeUtils;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UneartherFrameBlock
extends Block
implements EntityBlock {
    private static final Map<Part, VoxelShape> SHAPES = (Map)Util.make(new EnumMap(Part.class), map -> {
        map.put(Part.LOWER_CORNER, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), UneartherFrameBlock.box((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), UneartherFrameBlock.box((double)4.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0), UneartherFrameBlock.box((double)1.0, (double)8.0, (double)4.0, (double)3.0, (double)16.0, (double)16.0)));
        map.put(Part.LOWER_EDGE, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), UneartherFrameBlock.box((double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0)));
        map.put(Part.MID_EDGE, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), UneartherFrameBlock.box((double)4.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0), UneartherFrameBlock.box((double)1.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0, (double)16.0)));
        map.put(Part.MID_FACE, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0)));
        map.put(Part.UPPER_CORNER, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), UneartherFrameBlock.box((double)4.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), UneartherFrameBlock.box((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)16.0), UneartherFrameBlock.box((double)4.0, (double)0.0, (double)1.0, (double)16.0, (double)12.0, (double)3.0), UneartherFrameBlock.box((double)1.0, (double)0.0, (double)4.0, (double)3.0, (double)12.0, (double)16.0), UneartherFrameBlock.box((double)4.0, (double)13.0, (double)4.0, (double)16.0, (double)15.0, (double)16.0)));
        map.put(Part.UPPER_EDGE, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), UneartherFrameBlock.box((double)0.0, (double)13.0, (double)4.0, (double)16.0, (double)15.0, (double)16.0), UneartherFrameBlock.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)12.0, (double)3.0)));
        map.put(Part.UPPER_FACE, VoxelShapeUtils.or(UneartherFrameBlock.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0)));
    });
    private static final Map<Direction, Map<Part, VoxelShape>> D_SHAPES = (Map)Util.make(new EnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, SHAPES);
        map.put(Direction.EAST, UneartherFrameBlock.rotate(SHAPES, 90));
        map.put(Direction.SOUTH, UneartherFrameBlock.rotate(SHAPES, 180));
        map.put(Direction.WEST, UneartherFrameBlock.rotate(SHAPES, 270));
    });
    private final Part part;

    private static Map<Part, VoxelShape> rotate(Map<Part, VoxelShape> map, int rot) {
        return (Map)Util.make(new EnumMap(Part.class), res -> map.forEach((part, shape) -> res.put(part, VoxelShapeUtils.rotateY(shape, rot))));
    }

    public UneartherFrameBlock(BlockBehaviour.Properties properties, Part part) {
        super(properties);
        this.part = part;
        BlockState state = (BlockState)this.getStateDefinition().any();
        state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        this.registerDefaultState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UneartherFrameBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof UneartherFrameBlockEntity) {
            UneartherFrameBlockEntity frame = (UneartherFrameBlockEntity)blockEntity;
            frame.getCore().ifPresent(core -> level.destroyBlock(core.getBlockPos(), true));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return D_SHAPES.get(dir).get((Object)this.part);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof UneartherFrameBlockEntity) {
            UneartherFrameBlockEntity be = (UneartherFrameBlockEntity)blockEntity;
            be.getCore().ifPresent(core -> player.openMenu((MenuProvider)core, core.getBlockPos()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public static enum Part {
        LOWER_CORNER,
        LOWER_EDGE,
        MID_EDGE,
        MID_FACE,
        UPPER_CORNER,
        UPPER_EDGE,
        UPPER_FACE;

    }
}

