/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.client;

import dev.ftb.mods.ftbunearthed.client.UneartherRenderer;
import dev.ftb.mods.ftbunearthed.client.UneartherScreen;
import dev.ftb.mods.ftbunearthed.client.WorkerRenderer;
import dev.ftb.mods.ftbunearthed.item.WorkerToken;
import dev.ftb.mods.ftbunearthed.registry.ModBlockEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModEntityTypes;
import dev.ftb.mods.ftbunearthed.registry.ModItems;
import dev.ftb.mods.ftbunearthed.registry.ModMenuTypes;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="ftbunearthed", dist={Dist.CLIENT})
public class FTBUnearthedClient {
    private static final int[] COLORS = new int[]{-5000785, -2576493, -131210, -12455036, -13374517};

    public FTBUnearthedClient(IEventBus modEventBus) {
        modEventBus.addListener(FTBUnearthedClient::registerScreens);
        modEventBus.addListener(FTBUnearthedClient::registerRenderers);
        modEventBus.addListener(FTBUnearthedClient::registerItemColorHandlers);
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.UNEARTHER_CORE.get(), UneartherRenderer::new);
        event.registerEntityRenderer(ModEntityTypes.WORKER.get(), WorkerRenderer::new);
    }

    private static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.UNEARTHER_MENU.get(), UneartherScreen::new);
    }

    private static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> WorkerToken.getOptionalWorkerData(stack).filter(data -> tintIndex == 1).map(data -> COLORS[Math.clamp((long)data.getVillagerLevel(), 1, 5) - 1]).orElse(-1), new ItemLike[]{ModItems.WORKER_TOKEN.asItem()});
    }

    public static void updateBreakPositions(Collection<BlockPos> positions, int progress) {
        positions.forEach(pos -> Minecraft.getInstance().level.destroyBlockProgress(-pos.hashCode(), pos, progress));
    }
}

