/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbunearthed.FTBUnearthedTags;
import dev.ftb.mods.ftbunearthed.config.ServerConfig;
import dev.ftb.mods.ftbunearthed.registry.ModDataComponents;
import dev.ftb.mods.ftbunearthed.registry.ModItems;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class WorkerToken
extends Item {
    private static final int[] WORKER_XP_TABLE = new int[]{0, 40, 280, 600, 1000};

    public WorkerToken(Item.Properties properties) {
        super(properties);
    }

    public static void addTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().is(FTBUnearthedTags.Items.WORKER_TOKENS)) {
            WorkerData data = WorkerToken.getWorkerData(event.getItemStack());
            if (!data.hideTooltip) {
                List toolTip = event.getToolTip();
                toolTip.add(WorkerToken.tooltipLine("worker_profession", data.getProfessionName()));
                toolTip.add(WorkerToken.tooltipLine("worker_type", data.getVillagerTypeName()));
                toolTip.add(WorkerToken.tooltipLine("worker_level", Component.translatable((String)("merchant.level." + data.getVillagerLevel())).append(" (" + data.getVillagerLevel() + ")")));
                int progress = WorkerToken.getXPProgress(event.getItemStack());
                if (progress > 0 && progress < 100) {
                    toolTip.add(WorkerToken.tooltipLine("worker_xp_progress", Integer.toString(progress)));
                }
            }
        }
    }

    public static Component tooltipLine(String what, MutableComponent value) {
        return Component.translatable((String)("ftbunearthed.tooltip." + what), (Object[])new Object[]{value.withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.YELLOW);
    }

    public static Component tooltipLine(String what, String value) {
        return WorkerToken.tooltipLine(what, Component.literal((String)value));
    }

    public static void setWorkerData(ItemStack token, WorkerData data) {
        token.set(ModDataComponents.WORKER_DATA, (Object)data);
    }

    public static ItemStack createWithData(WorkerData data) {
        return (ItemStack)Util.make((Object)new ItemStack((ItemLike)ModItems.WORKER_TOKEN.get()), s -> WorkerToken.setWorkerData(s, data));
    }

    public Component getName(ItemStack stack) {
        Component defName = super.getName(stack);
        WorkerData data = WorkerToken.getWorkerData(stack);
        return defName.copy().append(" (").append((Component)data.getProfessionName()).append(")");
    }

    public static Optional<WorkerData> getOptionalWorkerData(ItemStack stack) {
        return Optional.ofNullable((WorkerData)stack.get(ModDataComponents.WORKER_DATA));
    }

    public static WorkerData getWorkerData(ItemStack stack) {
        return WorkerToken.getOptionalWorkerData(stack).orElse(WorkerData.UNEMPLOYED);
    }

    public static boolean addWorkerXP(ItemStack stack, int amount) {
        WorkerData data = WorkerToken.getWorkerData(stack);
        int lvl = data.getVillagerLevel();
        if (data.profession == VillagerProfession.NONE || lvl >= 5) {
            return false;
        }
        int currentXP = WorkerToken.getWorkerXP(stack, data);
        int neededXP = WORKER_XP_TABLE[data.getVillagerLevel()];
        int newXP = currentXP + amount;
        boolean levelUp = false;
        if (currentXP < neededXP && newXP >= neededXP) {
            levelUp = true;
            WorkerToken.setWorkerData(stack, new WorkerData(data.profession, data.type, Optional.of(data.getVillagerLevel() + 1), data.hideTooltip));
        }
        stack.set(ModDataComponents.WORKER_XP, (Object)newXP);
        return levelUp;
    }

    public static int getXPProgress(ItemStack stack) {
        WorkerData data = WorkerToken.getWorkerData(stack);
        int lvl = data.getVillagerLevel();
        int currentXP = WorkerToken.getWorkerXP(stack, data);
        if (data.profession == VillagerProfession.NONE || lvl < 1) {
            return 0;
        }
        if (data.getVillagerLevel() >= 5) {
            return 100;
        }
        int thisLvl = WORKER_XP_TABLE[lvl - 1];
        int nextLvl = WORKER_XP_TABLE[lvl];
        return (currentXP - thisLvl) * 100 / (nextLvl - thisLvl);
    }

    private static int getWorkerXP(ItemStack stack, WorkerData data) {
        Integer xp = (Integer)stack.get(ModDataComponents.WORKER_XP.get());
        return Objects.requireNonNullElseGet(xp, () -> WORKER_XP_TABLE[data.getVillagerLevel() - 1]);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (player != null) {
                BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
                Villager villager = new Villager(EntityType.VILLAGER, (Level)level2);
                villager.setPos(Vec3.atBottomCenterOf((Vec3i)pos));
                villager.lookAt(EntityAnchorArgument.Anchor.EYES, player.getEyePosition());
                level2.addFreshEntity((Entity)villager);
                WorkerData workerData = WorkerToken.getWorkerData(context.getItemInHand());
                if (workerData.profession() != VillagerProfession.NONE) {
                    villager.setVillagerXp(Math.max(1, VillagerData.getMinXpPerLevel((int)workerData.getVillagerLevel())));
                }
                villager.setVillagerData(workerData.toVillagerData());
                level2.playSound(null, villager.blockPosition(), SoundEvents.ENDER_PEARL_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 vec = villager.getPosition(1.0f).add(0.0, 0.0, 0.0);
                level2.sendParticles((ParticleOptions)ParticleTypes.PORTAL, vec.x, vec.y, vec.z, 50, 0.2, 0.2, 0.2, 0.1);
                if (!player.isCreative()) {
                    player.getItemInHand(context.getHand()).shrink(1);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
    }

    public record WorkerData(VillagerProfession profession, Optional<VillagerType> type, Optional<Integer> level, boolean hideTooltip) implements BiPredicate<ItemStack, Boolean>
    {
        public static final Codec<WorkerData> COMPONENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.VILLAGER_PROFESSION.byNameCodec().fieldOf("profession").forGetter(WorkerData::profession), (App)BuiltInRegistries.VILLAGER_TYPE.byNameCodec().optionalFieldOf("type").forGetter(WorkerData::type), (App)Codec.INT.optionalFieldOf("level").forGetter(WorkerData::level), (App)Codec.BOOL.optionalFieldOf("hide_tooltip", (Object)false).forGetter(WorkerData::hideTooltip)).apply((Applicative)builder, WorkerData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WorkerData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.VILLAGER_PROFESSION), WorkerData::profession, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.VILLAGER_TYPE)), WorkerData::type, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT), WorkerData::level, (StreamCodec)ByteBufCodecs.BOOL, WorkerData::hideTooltip, WorkerData::new);
        public static final WorkerData UNEMPLOYED = new WorkerData(VillagerProfession.NONE, 1);

        public WorkerData(VillagerProfession profession) {
            this(profession, Optional.empty(), Optional.empty(), false);
        }

        public WorkerData(VillagerProfession profession, VillagerType type) {
            this(profession, Optional.of(type), Optional.empty(), false);
        }

        public WorkerData(VillagerProfession profession, int level) {
            this(profession, Optional.empty(), Optional.of(level), false);
        }

        public static WorkerData fromVillagerData(VillagerData data) {
            Optional<Integer> lvl = (Boolean)ServerConfig.ENCODER_KEEPS_VILLAGER_LEVEL.get() != false ? Optional.of(data.getLevel()) : Optional.empty();
            VillagerType type = ServerConfig.encodedVillagerType().orElse(data.getType());
            return new WorkerData(data.getProfession(), Optional.of(type), lvl, false);
        }

        public WorkerData hideTooltip(boolean hide) {
            return new WorkerData(this.profession, this.type, this.level, hide);
        }

        @Override
        public boolean test(ItemStack workerStack, Boolean ignoreLevel) {
            return WorkerToken.getOptionalWorkerData(workerStack).map(data -> {
                if (!data.profession.equals((Object)this.profession)) {
                    return false;
                }
                if (this.type.isPresent() && !data.type.equals(this.type)) {
                    return false;
                }
                return ignoreLevel != false || data.getVillagerLevel() >= this.getVillagerLevel();
            }).orElse(false);
        }

        public int getVillagerLevel() {
            return this.level().orElse(1);
        }

        public VillagerData toVillagerData() {
            return new VillagerData(this.type.orElse(VillagerType.PLAINS), this.profession, this.getVillagerLevel());
        }

        public MutableComponent getProfessionName() {
            return Component.translatable((String)("entity.minecraft.villager." + this.profession.toString()));
        }

        public MutableComponent getVillagerTypeName() {
            ResourceLocation id = BuiltInRegistries.VILLAGER_TYPE.getKey((Object)this.type().orElse(VillagerType.PLAINS));
            return Component.translatable((String)("ftbunearthed.villager_type." + id.toShortLanguageKey()));
        }
    }
}

