/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbunearthed.net;

import dev.ftb.mods.ftbunearthed.FTBUnearthed;
import dev.ftb.mods.ftbunearthed.client.FTBUnearthedClient;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SendMultibreakProgressMessage(BlockPos pos0, List<BlockPos> offsets, int progress) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, BlockPos> BLOCKPOS_OFFSET_CODEC = StreamCodec.of((buffer, value) -> {
        buffer.writeByte(value.getX());
        buffer.writeByte(value.getY());
        buffer.writeByte(value.getZ());
    }, buffer -> new BlockPos((int)buffer.readByte(), (int)buffer.readByte(), (int)buffer.readByte()));
    public static final StreamCodec<FriendlyByteBuf, SendMultibreakProgressMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SendMultibreakProgressMessage::pos0, (StreamCodec)BLOCKPOS_OFFSET_CODEC.apply(ByteBufCodecs.list()), SendMultibreakProgressMessage::offsets, (StreamCodec)ByteBufCodecs.VAR_INT, SendMultibreakProgressMessage::progress, SendMultibreakProgressMessage::new);
    public static final CustomPacketPayload.Type<SendMultibreakProgressMessage> TYPE = new CustomPacketPayload.Type(FTBUnearthed.id("send_multibreak_progress"));

    public static SendMultibreakProgressMessage create(BlockPos pos0, Collection<BlockPos> allPositions, int progress) {
        List<BlockPos> offsets = allPositions.stream().map(p -> p.subtract((Vec3i)pos0)).toList();
        return new SendMultibreakProgressMessage(pos0, offsets, progress);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private List<BlockPos> getPositions() {
        return this.offsets.stream().map(arg_0 -> ((BlockPos)this.pos0).offset(arg_0)).toList();
    }

    public static void handle(SendMultibreakProgressMessage message, IPayloadContext ignoredContext) {
        FTBUnearthedClient.updateBreakPositions(message.getPositions(), message.progress);
    }
}

