/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.entity.Sludgeling;
import dev.ftb.mods.ftboceanmobs.registry.ModEntityTypes;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AbyssalSludge
extends BaseRiftMob {
    private static final RawAnimation ANIM_ATTACK_SPLASH = RawAnimation.begin().thenPlay("attack.splash");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final EntityDataAccessor<Boolean> DATA_SLUDGE_WARMUP = SynchedEntityData.defineId(AbyssalSludge.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int sludgeWarmupTicks = 0;
    private int nextSludgeTick = 0;

    public AbyssalSludge(EntityType<? extends AbyssalSludge> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.MAX_HEALTH, 75.0).add(Attributes.ARMOR, 8.0).add(Attributes.ARMOR_TOUGHNESS, 6.0).add(Attributes.FOLLOW_RANGE, 42.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.ATTACK_DAMAGE, 9.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SLUDGE_WARMUP, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ThrowSludgeGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericWalkIdleController((GeoAnimatable)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 5, this::attackState));
    }

    private PlayState attackState(AnimationState<AbyssalSludge> state) {
        state.setControllerSpeed(1.0f);
        if (this.swinging) {
            state.setControllerSpeed(2.0f);
            return state.setAndContinue(DefaultAnimations.ATTACK_STRIKE);
        }
        if (((Boolean)this.getEntityData().get(DATA_SLUDGE_WARMUP)).booleanValue()) {
            return state.setAndContinue(ANIM_ATTACK_SPLASH);
        }
        return PlayState.STOP;
    }

    public int getCurrentSwingDuration() {
        return (Boolean)this.entityData.get(DATA_SLUDGE_WARMUP) != false ? 24 : 15;
    }

    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (super.doHurtTarget(entity)) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 30 + entity.getRandom().nextInt(40), 3));
                return true;
            }
        }
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.level().random.nextBoolean()) {
            this.playSound(SoundEvents.SLIME_SQUISH, 1.0f, 0.75f);
        } else {
            this.playSound(SoundEvents.SLIME_JUMP, 1.0f, 1.0f);
        }
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SLIME_DEATH;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.ABYSSAL_SLUDGE_AMBIENT.get();
    }

    private static class ThrowSludgeGoal
    extends Goal {
        private static final int SLUDGE_WARMUP_TICKS = 24;
        private static final TargetingConditions SLIME_COUNT_TARGETING = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        private final AbyssalSludge abyssalSludge;

        public ThrowSludgeGoal(AbyssalSludge abyssalSludge) {
            this.abyssalSludge = abyssalSludge;
        }

        public boolean canUse() {
            LivingEntity target = this.abyssalSludge.getTarget();
            if (target != null && target.isAlive() && this.abyssalSludge.canAttack(target) && this.abyssalSludge.distanceToSqr((Entity)target) >= 25.0 && this.abyssalSludge.tickCount >= this.abyssalSludge.nextSludgeTick) {
                int nSlimes = this.abyssalSludge.level().getNearbyEntities(Slime.class, SLIME_COUNT_TARGETING, (LivingEntity)this.abyssalSludge, this.abyssalSludge.getBoundingBox().inflate(16.0)).size();
                return nSlimes < 12;
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity target = this.abyssalSludge.getTarget();
            return this.abyssalSludge.sludgeWarmupTicks > 0 && target != null && target.isAlive() && this.abyssalSludge.canAttack(target);
        }

        public void start() {
            this.abyssalSludge.getEntityData().set(DATA_SLUDGE_WARMUP, (Object)true);
            this.abyssalSludge.sludgeWarmupTicks = this.adjustedTickDelay(24);
            this.abyssalSludge.nextSludgeTick = this.abyssalSludge.tickCount + this.abyssalSludge.level().random.nextInt(40) + 40 + 24;
        }

        public void stop() {
            this.abyssalSludge.getEntityData().set(DATA_SLUDGE_WARMUP, (Object)false);
        }

        public void tick() {
            Level level;
            if (--this.abyssalSludge.sludgeWarmupTicks == 4 && this.abyssalSludge.getTarget() != null && (level = this.abyssalSludge.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.abyssalSludge.lookControl.setLookAt((Entity)this.abyssalSludge.getTarget());
                Vec3 look = this.abyssalSludge.getLookAngle().normalize();
                Vec3 pos = this.abyssalSludge.getEyePosition().add(look.scale(0.5));
                Sludgeling sludgeling = (Sludgeling)ModEntityTypes.SLUDGELING.get().create((Level)serverLevel);
                if (sludgeling != null) {
                    Vec3 vec = this.abyssalSludge.getTarget().position().subtract(this.abyssalSludge.position());
                    sludgeling.setDeltaMovement(vec.scale(0.125));
                    sludgeling.moveTo(pos, 0.0f, 0.0f);
                    sludgeling.setTarget(this.abyssalSludge.getTarget());
                    sludgeling.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.abyssalSludge.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
                    sludgeling.setSize(2, false);
                    sludgeling.setHealth(sludgeling.getMaxHealth());
                    serverLevel.addFreshEntityWithPassengers((Entity)sludgeling);
                    serverLevel.gameEvent((Holder)GameEvent.ENTITY_PLACE, BlockPos.containing((Position)pos), GameEvent.Context.of((Entity)this.abyssalSludge));
                    this.abyssalSludge.playSound(SoundEvents.SLIME_BLOCK_HIT, 1.0f, 0.5f);
                }
            }
        }
    }
}

