/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity;

import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.mobai.DelayedMeleeAttackGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ShadowBeast
extends BaseRiftMob {
    private static final RawAnimation ANIM_ATTACK_ROAR = RawAnimation.begin().thenPlay("attack.roar");
    protected static final EntityDataAccessor<Boolean> DATA_ROAR_WARMUP = SynchedEntityData.defineId(ShadowBeast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int nextRoarTick;
    private int roarWarmupTick;

    public ShadowBeast(EntityType<? extends ShadowBeast> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.45f).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.ARMOR, 2.0).add(Attributes.ARMOR_TOUGHNESS, 4.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 0.3333333432674408).add(Attributes.GRAVITY, 0.015).add(Attributes.ATTACK_DAMAGE, 7.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ROAR_WARMUP, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new ShadowRoarGoal(this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(3, (Goal)new DelayedMeleeAttackGoal((PathfinderMob)this, 1.0, false, 12));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Idle", 10, this::walkIdleRegenState));
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 5, this::attackState));
    }

    private PlayState attackState(AnimationState<ShadowBeast> state) {
        state.setControllerSpeed(1.0f);
        if (this.isRoaring()) {
            return state.setAndContinue(ANIM_ATTACK_ROAR);
        }
        if (this.swinging) {
            return state.setAndContinue(DefaultAnimations.ATTACK_STRIKE);
        }
        return PlayState.STOP;
    }

    private PlayState walkIdleRegenState(AnimationState<ShadowBeast> state) {
        state.setControllerSpeed(1.0f);
        if (state.isMoving()) {
            state.setControllerSpeed(3.0f);
            state.setAnimation(DefaultAnimations.WALK);
        } else {
            state.setAnimation(DefaultAnimations.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public boolean isRoaring() {
        return (Boolean)this.entityData.get(DATA_ROAR_WARMUP);
    }

    private void setRoaring(boolean roaring) {
        this.entityData.set(DATA_ROAR_WARMUP, (Object)roaring);
    }

    public int getCurrentSwingDuration() {
        return this.isRoaring() ? 40 : 20;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SHADOWBEAST_AMBIENT.get();
    }

    @Override
    public void playDelayedAttackSound() {
        this.playSound((SoundEvent)ModSounds.SHADOWBEAST_ATTACK.get());
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SHADOWBEAST_DEATH.get();
    }

    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (super.doHurtTarget(entity)) {
                if (entity.getRandom().nextInt(6) == 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40 + entity.getRandom().nextInt(40)));
                }
                return true;
            }
        }
        return false;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static class ShadowRoarGoal
    extends Goal {
        private static final int ROAR_WARMUP_TIME = 40;
        private final ShadowBeast shadowBeast;

        public ShadowRoarGoal(ShadowBeast shadowBeast) {
            this.shadowBeast = shadowBeast;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.shadowBeast.getTarget() != null && this.shadowBeast.tickCount >= this.shadowBeast.nextRoarTick && this.shadowBeast.distanceToSqr((Entity)this.shadowBeast.getTarget()) >= 16.0;
        }

        public boolean canContinueToUse() {
            return this.shadowBeast.roarWarmupTick >= 0;
        }

        public void start() {
            this.shadowBeast.setRoaring(true);
            this.shadowBeast.getNavigation().stop();
            if (this.shadowBeast.getTarget() != null) {
                this.shadowBeast.getLookControl().setLookAt((Entity)this.shadowBeast.getTarget(), 45.0f, 10.0f);
            }
            this.shadowBeast.roarWarmupTick = this.adjustedTickDelay(40);
            this.shadowBeast.nextRoarTick = this.shadowBeast.tickCount + this.shadowBeast.getRandom().nextInt(40) + 40 + 40;
        }

        public void stop() {
            this.shadowBeast.setRoaring(false);
        }

        public void tick() {
            --this.shadowBeast.roarWarmupTick;
            if (this.shadowBeast.roarWarmupTick == 16) {
                this.shadowBeast.playSound((SoundEvent)ModSounds.SHADOWBEAST_ROAR.get(), 1.0f, 0.5f);
            } else if (this.shadowBeast.roarWarmupTick == 10) {
                this.shadowBeast.level().getNearbyEntities(Player.class, TargetingConditions.DEFAULT, (LivingEntity)this.shadowBeast, this.shadowBeast.getBoundingBox().inflate(16.0)).forEach(player -> {
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40 + this.shadowBeast.getRandom().nextInt(60), 3));
                    player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 60 + this.shadowBeast.getRandom().nextInt(20), 0));
                });
            }
        }
    }
}

