/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.entity.riftweaver;

import dev.ftb.mods.ftboceanmobs.Config;
import dev.ftb.mods.ftboceanmobs.FTBOceanMobs;
import dev.ftb.mods.ftboceanmobs.FTBOceanMobsTags;
import dev.ftb.mods.ftboceanmobs.entity.BaseRiftMob;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.ChainsEncaser;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverMode;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverModes;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.RiftWeaverPart;
import dev.ftb.mods.ftboceanmobs.entity.riftweaver.SeismicSmasher;
import dev.ftb.mods.ftboceanmobs.mobai.RandomAttackableTargetGoal;
import dev.ftb.mods.ftboceanmobs.registry.ModSounds;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RiftWeaverBoss
extends Monster
implements GeoEntity {
    public static final int ARENA_HEIGHT = 32;
    public static final int MAX_ROAM_HEIGHT = 7;
    protected static final EntityDataAccessor<Boolean> HAS_ARMOR = SynchedEntityData.defineId(RiftWeaverBoss.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> FRENZIED = SynchedEntityData.defineId(RiftWeaverBoss.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<String> MODE = SynchedEntityData.defineId(RiftWeaverBoss.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final RawAnimation SLASH_ANIMATION = RawAnimation.begin().thenPlay("attack.slash");
    public static final RawAnimation SURGE_ANIMATION = RawAnimation.begin().thenPlay("attack.tidal_surge");
    public static final RawAnimation SMASH_ANIMATION = RawAnimation.begin().thenPlay("attack.seismic_smash");
    public static final RawAnimation FRENZY_ANIMATION = RawAnimation.begin().thenPlay("attack.riftclaw_frenzy");
    public static final RawAnimation CHAINS_ANIMATION = RawAnimation.begin().thenPlay("attack.chains");
    private static final ResourceLocation FRENZY_DMG_ID = FTBOceanMobs.id("frenzy_damage");
    private static final AttributeModifier FRENZY_DMG = new AttributeModifier(FRENZY_DMG_ID, 6.0, AttributeModifier.Operation.ADD_VALUE);
    public static final TargetingConditions NOT_RIFT_MOBS = TargetingConditions.DEFAULT.copy().selector(e -> !e.getType().is(FTBOceanMobsTags.Entity.RIFT_MOBS));
    private static final float DAMAGE_CAP_ARMOR = 3.0f;
    private static final float DAMAGE_CAP_NO_ARMOR = 15.0f;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent((Component)Component.translatable((String)"entity.ftboceanmobs.rift_weaver"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_12).setDarkenScreen(true);
    private final RiftWeaverPart[] subParts;
    private final RiftWeaverPart body;
    private final RiftWeaverPart head;
    private final RiftWeaverPart arm1;
    private final RiftWeaverPart arm2;
    private int fightPhase = -1;
    private RiftWeaverMode currentMode = RiftWeaverModes.HOLD_POSITION;
    private RiftWeaverMode lastMode = RiftWeaverModes.HOLD_POSITION;
    private RiftWeaverMode queuedMode = null;
    private BlockPos spawnPos = null;
    private int modeTicksRemaining = 0;
    BlockPos roamTarget;
    private long nextFireballTime = 0L;
    long nextMeleeSlash = 0L;
    long nextChainsAttack = 0L;
    private float armorDurability = 0.0f;
    SeismicSmasher seismicSmasher;
    ChainsEncaser chainsEncaser;
    private float accumulatedDmg = 0.0f;

    public RiftWeaverBoss(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.head = new RiftWeaverPart(this, 4.0f, 3.0f);
        this.body = new RiftWeaverPart(this, 3.5f, 9.0f);
        this.arm1 = new RiftWeaverPart(this, 2.5f, 9.5f);
        this.arm2 = new RiftWeaverPart(this, 2.5f, 9.5f);
        this.subParts = new RiftWeaverPart[]{this.head, this.body, this.arm1, this.arm2};
        this.noPhysics = true;
        this.setNoGravity(true);
        this.setId(ENTITY_COUNTER.getAndAdd(this.subParts.length + 1) + 1);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subParts.length; ++i) {
            this.subParts[i].setId(id + i + 1);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FLYING_SPEED, (double)0.9f).add(Attributes.MOVEMENT_SPEED, (double)0.27f).add(Attributes.MAX_HEALTH, 1000.0).add(Attributes.ARMOR, 4.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.75).add(Attributes.ATTACK_KNOCKBACK, 2.5).add(Attributes.ATTACK_DAMAGE, 12.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_ARMOR, (Object)false);
        builder.define(FRENZIED, (Object)false);
        builder.define(MODE, (Object)RiftWeaverModes.HOLD_POSITION.getName());
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new RandomAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 60, true, false, e -> !e.getType().is(FTBOceanMobsTags.Entity.RIFT_MOBS)));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
        this.fightPhase = compound.getInt("fightPhase");
        this.currentMode = RiftWeaverModes.byNameElseHold(compound.getString("currentMode"));
        this.getEntityData().set(MODE, (Object)this.currentMode.getName());
        this.lastMode = RiftWeaverModes.byNameElseHold(compound.getString("lastMode"));
        this.queuedMode = compound.contains("queuedMode", 8) ? RiftWeaverModes.byNameElseHold(compound.getString("queuedMode")) : null;
        this.modeTicksRemaining = compound.getInt("modeCounter");
        this.spawnPos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"spawnPos").orElse(null);
        this.armorDurability = compound.getFloat("armorDurability");
        this.setArmorActive(compound.getBoolean("armorActive"));
        this.setFrenzied(compound.getBoolean("frenzied"));
        this.accumulatedDmg = compound.getFloat("accumulatedDmg");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("fightPhase", this.fightPhase);
        compound.putString("currentMode", this.currentMode.getName());
        compound.putString("lastMode", this.lastMode.getName());
        if (this.queuedMode != null) {
            compound.putString("queuedMode", this.queuedMode.getName());
        }
        if (this.modeTicksRemaining != 0) {
            compound.putInt("modeCounter", this.modeTicksRemaining);
        }
        if (this.spawnPos != null) {
            compound.put("spawnPos", NbtUtils.writeBlockPos((BlockPos)this.spawnPos));
        }
        if (this.armorDurability > 0.0f) {
            compound.putFloat("armorDurability", this.armorDurability);
        }
        if (this.isArmorActive()) {
            compound.putBoolean("armorActive", true);
        }
        if (this.isFrenzied()) {
            compound.putBoolean("frenzied", true);
        }
        if (this.accumulatedDmg > 0.0f) {
            compound.putFloat("accumulatedDmg", this.accumulatedDmg);
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    protected boolean isFlapping() {
        return this.tickCount % 40 == 0;
    }

    protected void onFlap() {
        super.onFlap();
        if (this.level().isClientSide && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ENDER_DRAGON_FLAP, this.getSoundSource(), 5.0f, 0.6f + this.random.nextFloat() * 0.3f, false);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Attacking", 10, this::animState));
    }

    private PlayState animState(AnimationState<RiftWeaverBoss> state) {
        RawAnimation animation = Objects.requireNonNullElseGet(this.currentMode.getAnimation(), () -> state.isMoving() ? DefaultAnimations.FLY : DefaultAnimations.IDLE);
        return state.setAndContinue(animation);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void aiStep() {
        super.aiStep();
        this.processFlappingMovement();
        this.positionSubparts();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.RIFT_WEAVER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.RIFT_WEAVER_HURT.get();
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.RIFT_WEAVER_AMBIENT.get();
    }

    private void positionSubparts() {
        Vec3[] prevPartPos = new Vec3[this.subParts.length];
        for (int i = 0; i < this.subParts.length; ++i) {
            prevPartPos[i] = new Vec3(this.subParts[i].getX(), this.subParts[i].getY(), this.subParts[i].getZ());
        }
        this.updatePartPos(this.head, 0.0f, 14.0f, 0.0f);
        Vec3 velocity = this.getDeltaMovement();
        float avgVelocity = (float)(Math.abs(velocity.x) + Math.abs(velocity.z) / 2.0);
        if (avgVelocity > 0.015f) {
            this.head.setPos(this.head.getX() + velocity.x * 16.0, this.head.getY() - 3.0, this.head.getZ() + velocity.z * 16.0);
        }
        this.updatePartPos(this.body, 0.0f, 5.0f, 0.0f);
        float yawRad = this.yBodyRot * ((float)Math.PI / 180);
        float xOff = Mth.cos((float)yawRad);
        float zOff = Mth.sin((float)yawRad);
        this.updatePartPos(this.arm1, xOff * 2.5f, 4.5f, zOff * 4.5f);
        this.updatePartPos(this.arm2, -xOff * 2.5f, 4.5f, -zOff * 4.5f);
        for (int i = 0; i < this.subParts.length; ++i) {
            this.subParts[i].xo = prevPartPos[i].x;
            this.subParts[i].yo = prevPartPos[i].y;
            this.subParts[i].zo = prevPartPos[i].z;
            this.subParts[i].xOld = prevPartPos[i].x;
            this.subParts[i].yOld = prevPartPos[i].y;
            this.subParts[i].zOld = prevPartPos[i].z;
        }
    }

    private void updatePartPos(RiftWeaverPart part, float xOff, float yOff, float zOff) {
        part.setPos(this.getX() + (double)xOff, this.getY() + (double)yOff, this.getZ() + (double)zOff);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subParts;
    }

    public boolean isPickable() {
        return false;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime < 40 && this.deathTime % 4 == 0) {
            double x = this.getBoundingBox().minX + this.random.nextDouble() * this.getBoundingBox().getXsize();
            double y = this.getBoundingBox().minY + this.random.nextDouble() * this.getBoundingBox().getYsize();
            double z = this.getBoundingBox().minZ + this.random.nextDouble() * this.getBoundingBox().getZsize();
            this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.deathTime >= 40 && !this.level().isClientSide() && !this.isRemoved()) {
            this.remove(Entity.RemovalReason.KILLED);
            this.gameEvent((Holder)GameEvent.ENTITY_DIE);
            this.level().getEntities((Entity)this, new AABB(this.spawnPos).inflate((double)Config.arenaRadius), e -> e instanceof BaseRiftMob).forEach(Entity::kill);
        }
    }

    protected void customServerAiStep() {
        if (this.fightPhase == -1) {
            this.playSound((SoundEvent)ModSounds.RIFT_WEAVER_SUMMON.get());
            this.fightPhase = 0;
        }
        if (this.tickCount % 20 == 0 && this.isAlive()) {
            int nPlayers = this.countPlayersInArena();
            if (this.getHealth() < this.getMaxHealth()) {
                float regen = 0.0f;
                if (nPlayers == 0) {
                    regen = 50.0f;
                } else if (nPlayers > 1) {
                    regen = 5.0f + 3.0f * (float)(nPlayers - 2);
                }
                if (regen != 0.0f) {
                    this.setHealth(Math.min(this.getMaxHealth(), this.getHealth() + regen));
                }
            }
        }
        if (this.getEyePosition().y - 5.0 < (double)this.level().getHeight(Heightmap.Types.WORLD_SURFACE, this.blockPosition().getX(), this.blockPosition().getZ())) {
            this.moveTo(this.position().x, this.position().y + 2.0, this.position().z);
        }
        if (!this.hasRestriction()) {
            if (this.spawnPos == null) {
                this.spawnPos = this.blockPosition();
            }
            this.restrictTo(this.spawnPos, Config.arenaRadius);
        }
        if (this.modeTicksRemaining > 0 && --this.modeTicksRemaining == 0) {
            this.switchMode(this.lastMode);
        }
        this.currentMode.tickMode(this, this.modeTicksRemaining);
        if ((long)this.tickCount >= this.nextFireballTime) {
            this.shootFireball();
        }
        if (this.queuedMode != null && this.currentMode.isIdleMode()) {
            this.switchMode(this.queuedMode);
            this.queuedMode = null;
        }
        if (this.getTarget() != null && this.getTarget().isAlive()) {
            this.lookControl.setLookAt((Entity)this.getTarget());
            if (this.fightPhase >= 3 && (long)this.tickCount > this.nextChainsAttack) {
                this.queueMode(RiftWeaverModes.CHAINS);
            } else if (this.accumulatedDmg > this.getMaxHealth() / 5.0f && this.queuedMode == null && this.isAlive()) {
                this.queueMode(RiftWeaverModes.REINFORCE);
                this.accumulatedDmg = 0.0f;
            } else if (this.fightPhase >= 2 && this.random.nextInt(300) == 0) {
                this.queueMode(RiftWeaverModes.SEISMIC_SMASH);
            } else if ((long)this.tickCount >= this.nextMeleeSlash) {
                this.queueMode(RiftWeaverModes.MELEE_SLASH);
            }
        }
        if (this.fightPhase == 3 && !this.isFrenzied()) {
            this.forceQueueMode(RiftWeaverModes.RIFTCLAW_FRENZY);
        }
        if (this.armorDurability > 0.0f) {
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, -1, 2));
        }
        if (this.seismicSmasher != null && !this.seismicSmasher.tick()) {
            this.seismicSmasher = null;
        }
        if (this.chainsEncaser != null && !this.chainsEncaser.tick(this)) {
            this.chainsEncaser = null;
        }
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossEvent.removePlayer(player);
    }

    protected AABB makeBoundingBox() {
        return super.makeBoundingBox().move(0.0, 3.0, 0.0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (MODE == key) {
            this.currentMode = RiftWeaverModes.byNameElseHold((String)this.entityData.get(MODE));
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!source.is(Tags.DamageTypes.IS_TECHNICAL)) {
            amount = Math.min(amount, this.isArmorActive() && !source.is(Tags.DamageTypes.IS_MAGIC) ? 3.0f : 15.0f);
        }
        return super.hurt(source, amount);
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        float prevHealth = this.getHealth();
        float prevHealthPct = this.getHealth() / this.getMaxHealth();
        super.actuallyHurt(damageSource, damageAmount);
        float newHealthPct = this.getHealth() / this.getMaxHealth();
        if (this.armorDurability > 0.0f) {
            this.armorDurability = Math.max(0.0f, this.armorDurability - (prevHealth - this.getHealth()));
            if (this.armorDurability == 0.0f) {
                this.setArmorActive(false);
                this.removeEffect(MobEffects.REGENERATION);
            }
        }
        if (prevHealthPct >= 0.75f && newHealthPct < 0.75f) {
            this.advanceFightPhase(1);
        } else if (prevHealthPct >= 0.5f && newHealthPct < 0.5f) {
            this.advanceFightPhase(2);
        } else if (prevHealthPct >= 0.25f && newHealthPct < 0.25f) {
            this.advanceFightPhase(3);
        }
        this.accumulatedDmg += damageAmount;
    }

    protected float getFlyingSpeed() {
        return this.currentMode == RiftWeaverModes.MELEE_SLASH ? 0.15f : 0.05f;
    }

    public void checkDespawn() {
    }

    private void advanceFightPhase(int phase) {
        if (this.fightPhase < phase) {
            this.fightPhase = phase;
            this.forceQueueMode(RiftWeaverModes.TIDAL_SURGE);
            this.armorDurability = 20.0f;
            if (this.getHealth() > 0.0f) {
                this.setArmorActive(true);
            }
        }
    }

    public void forceQueueMode(RiftWeaverMode newMode) {
        this.queuedMode = newMode;
    }

    public void queueMode(RiftWeaverMode newMode) {
        if (this.queuedMode == null) {
            this.queuedMode = newMode;
        }
    }

    public void switchMode(RiftWeaverMode newMode) {
        if (newMode != this.currentMode) {
            this.currentMode.onModeEnd(this);
            this.lastMode = this.currentMode;
            this.currentMode = newMode;
            this.modeTicksRemaining = newMode.durationTicks();
            this.entityData.set(MODE, (Object)this.currentMode.getName());
            this.currentMode.onModeStart(this);
        }
    }

    private void shootFireball() {
        if (this.getTarget() != null && this.getTarget().isAlive() && !(this.getTarget() instanceof Player)) {
            Vec3 launchPos = this.getEyePosition(1.0f).add(this.getViewVector(1.0f).normalize().scale(6.0));
            Vec3 delta = this.getTarget().position().subtract(launchPos);
            SmallFireball fireball = switch (this.fightPhase) {
                case 0 -> new SmallFireball(this.level(), (LivingEntity)this, delta.normalize());
                case 1, 2 -> new LargeFireball(this.level(), (LivingEntity)this, delta.normalize().scale(2.0), 0);
                default -> new DragonFireball(this.level(), (LivingEntity)this, delta.normalize());
            };
            fireball.setPos(launchPos);
            this.level().addFreshEntity((Entity)fireball);
            this.level().levelEvent(null, 1017, this.blockPosition(), 0);
            long next = this.random.nextInt(this.isFrenzied() ? 5 : 3) == 0 ? (long)(70 + this.random.nextInt(50)) : 5L;
            this.nextFireballTime = (long)this.tickCount + next;
        }
    }

    public void setArmorActive(boolean active) {
        this.getEntityData().set(HAS_ARMOR, (Object)active);
        this.playSound(active ? (SoundEvent)SoundEvents.ARMOR_EQUIP_NETHERITE.value() : SoundEvents.SHIELD_BREAK, 5.0f, 1.0f);
    }

    public boolean isArmorActive() {
        return (Boolean)this.getEntityData().get(HAS_ARMOR);
    }

    public void setFrenzied(boolean frenzied) {
        this.getEntityData().set(FRENZIED, (Object)frenzied);
        AttributeInstance instance = Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE));
        instance.removeModifier(FRENZY_DMG_ID);
        if (frenzied) {
            instance.addTransientModifier(FRENZY_DMG);
        }
    }

    public boolean isFrenzied() {
        return (Boolean)this.getEntityData().get(FRENZIED);
    }

    int countPlayersInArena() {
        AABB aabb = new AABB(this.blockPosition()).inflate((double)Config.arenaRadius);
        return (int)this.level().getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)this, aabb).stream().filter(this::isInArena).count();
    }

    public boolean isInArena(Entity entity) {
        return this.spawnPos.distToCenterSqr(entity.getX(), entity.getY(), entity.getZ()) < (double)Config.arenaRadiusSq;
    }

    public boolean isInArena(BlockPos pos) {
        return pos.distSqr((Vec3i)this.spawnPos) < (double)Config.arenaRadiusSq;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    @EventBusSubscriber
    public static class Listener {
        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            if (event.getEntity() instanceof RiftWeaverBoss && event.getProjectile().getOwner() == event.getEntity()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onIncomingDamage(LivingIncomingDamageEvent event) {
            if (event.getEntity() instanceof RiftWeaverBoss && event.getSource().getEntity() == event.getEntity()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityJoin(EntityJoinLevelEvent event) {
            AreaEffectCloud cloud;
            Entity entity = event.getEntity();
            if (entity instanceof AreaEffectCloud && (cloud = (AreaEffectCloud)entity).getOwner() instanceof RiftWeaverBoss) {
                cloud.setDuration(200);
                cloud.setParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME);
            }
        }
    }
}

