/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.fluid;

import dev.ftb.mods.ftboceanmobs.fluid.FluidRenderProps;
import dev.ftb.mods.ftboceanmobs.registry.ModBlocks;
import dev.ftb.mods.ftboceanmobs.registry.ModFluids;
import dev.ftb.mods.ftboceanmobs.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class AbyssalWaterFluid {
    public static final FluidRenderProps RENDER_PROPS = new FluidRenderProps("minecraft:block/water_still", "minecraft:block/water_flow", -2141641069);

    private static BaseFlowingFluid.Properties props() {
        return new BaseFlowingFluid.Properties(ModFluids.ABYSSAL_WATER_TYPE, ModFluids.ABYSSAL_WATER, ModFluids.ABYSSAL_WATER_FLOWING).block(ModBlocks.ABYSSAL_WATER).bucket(ModItems.ABYSSAL_WATER_BUCKET).tickRate(5);
    }

    public static class Flowing
    extends BaseFlowingFluid.Flowing {
        public Flowing() {
            super(AbyssalWaterFluid.props());
        }

        public boolean canHydrate(FluidState state, BlockGetter getter, BlockPos pos, BlockState source, BlockPos sourcePos) {
            return source.getBlock() == Blocks.SPONGE || super.canHydrate(state, getter, pos, source, sourcePos);
        }

        protected void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
            if (!((Boolean)state.getValue((Property)FALLING)).booleanValue() && random.nextInt(64) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        }
    }

    public static class Source
    extends BaseFlowingFluid.Source {
        public Source() {
            super(AbyssalWaterFluid.props());
        }

        public boolean canHydrate(FluidState state, BlockGetter getter, BlockPos pos, BlockState source, BlockPos sourcePos) {
            return source.getBlock() == Blocks.SPONGE || super.canHydrate(state, getter, pos, source, sourcePos);
        }
    }
}

