/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.mobai;

import dev.ftb.mods.ftboceanmobs.integration.ftbchunks.FTBChunksIntegration;
import dev.ftb.mods.ftboceanmobs.mobai.IChargingMob;
import dev.ftb.mods.ftboceanmobs.util.MiscUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ChargeGoal
extends Goal {
    private static final double MIN_CHARGE_RANGE_SQ = 25.0;
    private static final double MAX_CHARGE_RANGE_SQ = 225.0;
    private static final float CHARGE_CHANCE = 0.12f;
    private static final int WARMUP_TICKS = 40;
    private final PathfinderMob mob;
    private final boolean canBreakBlocks;
    private final float speed;
    private LivingEntity target;
    private Vec3 chargePos;
    private int chargeWarmup;
    private boolean chargeSwipeDone;

    public ChargeGoal(PathfinderMob mob, float speed) {
        IChargingMob c;
        this.mob = mob;
        this.canBreakBlocks = mob instanceof IChargingMob && (c = (IChargingMob)mob).canBreakBlocksWhenCharging();
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.isStandingInFluid()) {
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        double distSq = this.mob.distanceToSqr((Entity)this.target);
        if (distSq < 25.0 || distSq > 225.0 || !this.mob.onGround() || this.mob.getRandom().nextFloat() > 0.12f || !this.mob.getSensing().hasLineOfSight((Entity)this.target) || !MiscUtil.canPathfindToTarget((Mob)this.mob, this.target, 2.25f)) {
            return false;
        }
        this.chargePos = ChargeGoal.calcChargePos(this.mob, this.target);
        return true;
    }

    public boolean canContinueToUse() {
        return this.target.isAlive() && this.mob.canAttack(this.target) && !this.isStandingInFluid() && (this.chargeWarmup > 0 || !this.mob.getNavigation().isDone());
    }

    public void start() {
        this.chargeWarmup = this.adjustedTickDelay(40);
        this.mob.setSprinting(true);
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof IChargingMob) {
            IChargingMob c = (IChargingMob)pathfinderMob;
            c.setWarmingUp();
        }
    }

    public void stop() {
        this.chargeWarmup = 0;
        this.target = null;
        this.chargeSwipeDone = false;
        this.mob.setSprinting(false);
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof IChargingMob) {
            IChargingMob c = (IChargingMob)pathfinderMob;
            c.resetCharging();
        }
    }

    public void tick() {
        this.mob.getLookControl().setLookAt(this.chargePos.x(), this.chargePos.y() - 1.0, this.chargePos.z(), 10.0f, (float)this.mob.getMaxHeadXRot());
        if (--this.chargeWarmup > 0) {
            this.mob.walkAnimation.setSpeed(this.mob.walkAnimation.speed() + 0.8f);
        } else {
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof IChargingMob) {
                IChargingMob c = (IChargingMob)pathfinderMob;
                c.setActuallyCharging();
            }
            this.chargePos = ChargeGoal.calcChargePos(this.mob, this.target);
            this.mob.getNavigation().moveTo(this.chargePos.x(), this.chargePos.y(), this.chargePos.z(), (double)this.speed);
        }
        if (this.canBreakBlocks && EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
            AABB aabb = this.mob.getBoundingBox().inflate(0.8, 0.0, 0.8).move(0.0, 1.1, 0.0);
            BlockPos min = BlockPos.containing((Position)aabb.getMinPosition());
            BlockPos max = BlockPos.containing((Position)aabb.getMaxPosition());
            if (this.mob.level().hasChunksAt(min, max)) {
                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)min, (BlockPos)max)) {
                    if (!ChargeGoal.canDestroyBlock(this.mob.level(), pos, (LivingEntity)this.mob)) continue;
                    this.mob.level().destroyBlock(pos, true);
                }
            }
        }
        double rangeSq = this.mob.getBbWidth() * 2.0f * this.mob.getBbWidth() * 2.0f + this.target.getBbWidth();
        if (this.mob.distanceToSqr(this.target.getX(), this.target.getBoundingBox().minY, this.target.getZ()) <= rangeSq && !this.chargeSwipeDone) {
            this.mob.doHurtTarget((Entity)this.target);
            this.chargeSwipeDone = true;
        }
    }

    private boolean isStandingInFluid() {
        return this.mob.level().getBlockState(this.mob.getOnPos().above()).getBlock() instanceof LiquidBlock;
    }

    private static Vec3 calcChargePos(PathfinderMob mob, LivingEntity target) {
        Vec3 offset = target.position().subtract(mob.position());
        return mob.position().add(offset.add(offset.normalize().scale(2.5)));
    }

    private static boolean canDestroyBlock(Level level, BlockPos pos, LivingEntity entity) {
        BlockState state = level.getBlockState(pos);
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        return hardness >= 0.0f && hardness < 50.0f && !state.isAir() && level.getBlockEntity(pos) == null && state.getBlock().canEntityDestroy(state, (BlockGetter)level, pos, (Entity)entity) && FTBChunksIntegration.canMobGriefBlocks(level, pos) && EventHooks.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)pos, (BlockState)state);
    }
}

