/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.mobai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChaseTargetGoal
extends Goal {
    private final PathfinderMob mob;
    @Nullable
    private LivingEntity target;
    private double wantedX;
    private double wantedY;
    private double wantedZ;
    private final double speedModifier;
    private final float within;
    private int ticksUntilPathRecalc;

    public ChaseTargetGoal(PathfinderMob mob, double speedModifier, float within) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.within = within;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        if (this.target.distanceToSqr((Entity)this.mob) > (double)(this.within * this.within)) {
            return false;
        }
        if (this.target.distanceToSqr((Entity)this.mob) < 49.0) {
            return false;
        }
        this.wantedX = this.target.getX();
        this.wantedY = this.target.getY();
        this.wantedZ = this.target.getZ();
        return true;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone() && this.target.isAlive() && this.target.distanceToSqr((Entity)this.mob) < (double)(this.within * this.within);
    }

    public void stop() {
        this.target = null;
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, 7, this.speedModifier);
        this.ticksUntilPathRecalc = 0;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.target);
        if (this.ticksUntilPathRecalc == 0) {
            this.wantedX = this.target.getX();
            this.wantedY = this.target.getY();
            this.wantedZ = this.target.getZ();
            boolean pathOk = this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, 1, this.speedModifier);
            this.ticksUntilPathRecalc = 4 + this.mob.getRandom().nextInt(7) + (pathOk ? 0 : 15);
        }
    }
}

