/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftboceanmobs.mobai;

import dev.ftb.mods.ftboceanmobs.entity.TumblingBlockEntity;
import dev.ftb.mods.ftboceanmobs.mobai.IThrowingMob;
import dev.ftb.mods.ftboceanmobs.util.MiscUtil;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ThrowBlockGoal
extends Goal {
    private final Mob mob;
    private final int totalTime;
    private final int pickupTime;
    private final int launchTime;
    private final float throwChance;
    private LivingEntity target;
    private int tickCounter;

    public ThrowBlockGoal(Mob mob, int totalTime, int pickupTime, int launchTime, float throwChance) {
        this.mob = mob;
        this.totalTime = ThrowBlockGoal.reducedTickDelay((int)totalTime);
        this.throwChance = throwChance;
        this.pickupTime = ThrowBlockGoal.reducedTickDelay((int)(totalTime - pickupTime));
        this.launchTime = ThrowBlockGoal.reducedTickDelay((int)(totalTime - launchTime));
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        this.target = this.mob.getTarget();
        return this.target != null && this.target.isAlive() && this.mob.level().random.nextFloat() < this.throwChance && (this.mob.distanceToSqr((Entity)this.target) > 256.0 || !MiscUtil.canPathfindToTarget(this.mob, this.target, 2.25f));
    }

    public boolean canContinueToUse() {
        return this.target.isAlive() && this.tickCounter > 0;
    }

    public void start() {
        this.tickCounter = this.totalTime;
        Mob mob = this.mob;
        if (mob instanceof IThrowingMob) {
            IThrowingMob tm = (IThrowingMob)mob;
            tm.setThrowing(true);
        }
    }

    public void stop() {
        Mob mob = this.mob;
        if (mob instanceof IThrowingMob) {
            IThrowingMob tm = (IThrowingMob)mob;
            tm.setThrowing(false);
        }
    }

    public void tick() {
        --this.tickCounter;
        this.mob.getLookControl().setLookAt((Entity)this.target);
        if (this.tickCounter == this.pickupTime) {
            BlockState state = this.mob.getBlockStateOn();
            this.mob.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)state.getBlock()));
            this.mob.level().levelEvent(2001, this.mob.blockPosition(), Block.getId((BlockState)state));
        } else if (this.tickCounter == this.launchTime) {
            ItemStack stack = this.mob.getItemBySlot(EquipmentSlot.OFFHAND);
            if (!stack.isEmpty() && stack.getItem() instanceof BlockItem) {
                Vec3 pos = this.mob.getEyePosition().add(0.0, 0.8, 0.0);
                TumblingBlockEntity t = new TumblingBlockEntity(this.mob.level(), (LivingEntity)this.mob, pos.x, pos.y, pos.z, stack);
                t.setDeltaMovement(this.target.position().add(0.0, 1.0, 0.0).subtract(this.mob.position()).scale(0.065));
                t.setOnGround(false);
                t.horizontalCollision = false;
                t.verticalCollision = false;
                this.mob.level().addFreshEntity((Entity)t);
            }
            this.mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        }
    }
}

