/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;

public record CollectFluidsBehavior() implements FunctionalUpgradeBehavior
{
    public static final CollectFluidsBehavior INSTANCE = new CollectFluidsBehavior();
    public static final MapCodec<CollectFluidsBehavior> CODEC = MapCodec.unit((Object)INSTANCE);
    private static final GameProfile FP = new GameProfile(UUID.nameUUIDFromBytes("FunctionalStorage-Pickup".getBytes(StandardCharsets.UTF_8)), "FunctionalStorage-Pickp");

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> dr, ItemStack upgradeStack, int upgradeSlot) {
        if (!(dr instanceof FluidDrawerTile)) {
            return;
        }
        FluidDrawerTile drawer = (FluidDrawerTile)dr;
        Direction direction = UpgradeItem.getDirection(upgradeStack);
        FluidState fluidstate = level.getFluidState(pos.relative(direction));
        if (!fluidstate.isEmpty() && fluidstate.isSource()) {
            FluidStack drained;
            BlockState state = level.getBlockState(pos.relative(direction));
            Block block = state.getBlock();
            BucketPickupHandlerWrapper targetFluidHandler = null;
            if (block instanceof BucketPickup) {
                targetFluidHandler = new BucketPickupHandlerWrapper((Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)FP), (BucketPickup)block, level, pos.relative(direction));
            }
            if (targetFluidHandler != null && !(drained = targetFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                for (int tankId = 0; tankId < drawer.getFluidHandler().getTanks(); ++tankId) {
                    BigFluidHandler.CustomFluidTank fluidTank = drawer.fluidHandler.getTankList()[tankId];
                    int insertedAmount = fluidTank.fill(drained, IFluidHandler.FluidAction.SIMULATE);
                    if (insertedAmount != drained.getAmount()) continue;
                    fluidTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                    if (!fluidstate.getType().canConvertToSource(fluidstate, level, pos.relative(direction))) {
                        targetFluidHandler.drain(insertedAmount, IFluidHandler.FluidAction.EXECUTE);
                    }
                    drawer.fluidHandler.onChange();
                    break;
                }
            }
        }
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }
}

