/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.block.proxy;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.block.proxy.DirectionalProxyCapabilityProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public abstract class DirectionalProxyBlock<T>
extends DirectionalBlock {
    public static final Property<Direction> FACINNG = DirectionalBlock.FACING;

    protected DirectionalProxyBlock(BlockBehaviour.Properties props) {
        super(props.requiredFeatures(new FeatureFlag[]{GAGRegistry.CAP_PROXY_FEATURE}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        LevelReader levelReader2 = levelReader;
        Objects.requireNonNull(levelReader2);
        LevelReader levelReader3 = levelReader2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Level.class}, (Object)levelReader3, n)) {
            case 0 -> {
                Level level = (Level)levelReader3;
                if (this.getCapability(level, pos, state) != null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    protected abstract BlockCapability<T, Direction> getProxiedCapability();

    @Nullable
    protected T getCapability(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return (T)level.getCapability(this.getProxiedCapability(), pos.relative(facing), (Object)facing.getOpposite());
    }

    protected void registerCapabilities(RegisterCapabilitiesEvent event) {
        BlockCapability<T, Direction> cap = this.getProxiedCapability();
        event.registerBlock(cap, new DirectionalProxyCapabilityProvider<T>(cap), new Block[]{this});
    }
}

