/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client;

import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.client.GAGClientEvents;
import ky.someone.mods.gag.client.render.TimeAcceleratorEntityRenderer;
import ky.someone.mods.gag.client.screen.LabelingMenuScreen;
import ky.someone.mods.gag.client.tooltip.HStackClientTooltip;
import ky.someone.mods.gag.client.tooltip.ItemClientTooltip;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.particle.client.MagicParticle;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.tooltip.HStackTooltipComponent;
import ky.someone.mods.gag.util.tooltip.ItemTooltipComponent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
public interface GAGClient {
    public static void init(IEventBus bus) {
        bus.register(GAGClient.class);
        NeoForge.EVENT_BUS.register(GAGClientEvents.class);
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)GAGRegistry.PIGMENT_JAR.asItem(), (ResourceLocation)GAGUtil.id("pigment_amount"), (stack, level, entity, seed) -> (float)PigmentJarItem.getPigment(stack).amount() / 64.0f));
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register(GAGRegistry.LABELING_MENU, LabelingMenuScreen::new);
    }

    @SubscribeEvent
    public static void registerColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, index) -> index == 0 ? 0xFF000000 | PigmentJarItem.getPigment(stack).rgb() : -1, new ItemLike[]{GAGRegistry.PIGMENT_JAR});
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)GAGRegistry.MAGIC_PARTICLE, MagicParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(GAGRegistry.TIME_ACCELERATOR.get(), TimeAcceleratorEntityRenderer::new);
        event.registerEntityRenderer(GAGRegistry.MINING_DYNAMITE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(GAGRegistry.FISHING_DYNAMITE.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void registerTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(HStackTooltipComponent.class, HStackClientTooltip::of);
        event.register(ItemTooltipComponent.class, ItemClientTooltip::new);
    }
}

