/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.item;

import java.util.List;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.item.GAGItem;
import ky.someone.mods.gag.item.data.TeleportPos;
import ky.someone.mods.gag.util.GAGUtil;
import ky.someone.mods.gag.util.TooltipStyle;
import ky.someone.mods.gag.util.Tooltips;
import ky.someone.mods.gag.util.tooltip.TooltipSink;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HearthstoneItem
extends GAGItem {
    public HearthstoneItem() {
        this(new Item.Properties().durability(GAGConfig.hearthstone.durability()));
    }

    public HearthstoneItem(Item.Properties properties) {
        super(properties);
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int ticks) {
        Vec3 pos = entity.position();
        double radius = 0.75;
        double spirals = 4.0;
        int i = 1;
        while ((double)i <= spirals) {
            double x = Math.cos(((double)ticks + Math.PI * 2 * (double)i) / spirals) * radius;
            double z = Math.sin(((double)ticks + Math.PI * 2 * (double)i) / spirals) * radius;
            level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, pos.x + x, pos.y + 0.1 * (20.0 - (double)ticks % 20.0), pos.z + z, 0.0, 0.0, 0.0);
            ++i;
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        player.startUsingItem(interactionHand);
        return InteractionResultHolder.success((Object)stack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return GAGConfig.hearthstone.warmup();
    }

    @Nullable
    public TeleportPos getTeleportPos(@Nullable Player player, ItemStack stack) {
        boolean allowSpawn = GAGConfig.hearthstone.allowWorldSpawn();
        boolean ignoreSpawnBlock = GAGConfig.hearthstone.ignoreSpawnBlock();
        boolean useAnchorCharge = GAGConfig.hearthstone.useAnchorCharge();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            MinecraftServer server = serverPlayer.server;
            serverPlayer = (ServerPlayer)player;
            ServerLevel respawnDim = server.getLevel(serverPlayer.getRespawnDimension());
            if (respawnDim != null) {
                DimensionTransition actualPos = serverPlayer.findRespawnPositionAndUseSpawnBlock(!useAnchorCharge, DimensionTransition.DO_NOTHING);
                if (!actualPos.missingRespawnBlock()) {
                    return new TeleportPos((ResourceKey<Level>)actualPos.newLevel().dimension(), actualPos.pos(), actualPos.yRot());
                }
            } else {
                respawnDim = server.overworld();
            }
            if (allowSpawn) {
                Vec3 spawnPos = Vec3.atBottomCenterOf((Vec3i)respawnDim.getSharedSpawnPos());
                return new TeleportPos((ResourceKey<Level>)respawnDim.dimension(), spawnPos, serverPlayer.getRespawnAngle());
            }
        }
        return null;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.isClientSide && entity instanceof ServerPlayer) {
            ServerLevel targetLevel;
            ServerPlayer player = (ServerPlayer)entity;
            TeleportPos target = this.getTeleportPos((Player)player, stack);
            if (target != null && (targetLevel = player.server.getLevel(target.level())) != null) {
                return this.tryTeleport(stack, targetLevel, player, target.pos(), target.yaw());
            }
            player.sendSystemMessage((Component)this.getTranslation("no_target", new Object[0]).withStyle(ChatFormatting.RED));
            level.playSound(null, player.blockPosition(), (SoundEvent)GAGRegistry.TELEPORT_FAIL.value(), SoundSource.PLAYERS, 0.6f, 1.0f);
        }
        return stack;
    }

    private ItemStack tryTeleport(ItemStack stack, ServerLevel level, ServerPlayer player, Vec3 pos, float yaw) {
        boolean creative = player.isCreative();
        int durabilityUsed = level.equals(player.serverLevel()) ? 1 : GAGConfig.hearthstone.dimensionMultiplier();
        double distance = player.position().distanceTo(pos) * (double)durabilityUsed;
        int range = GAGConfig.hearthstone.range();
        if (durabilityUsed > 0) {
            if (range < 0 || distance < (double)range) {
                InteractionHand hand = player.getUsedItemHand();
                stack.hurtAndBreak(durabilityUsed, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                player.teleportTo(level, pos.x, pos.y, pos.z, yaw, 0.0f);
                level.playSound(null, player.blockPosition(), (SoundEvent)GAGRegistry.TELEPORT.value(), SoundSource.PLAYERS, 0.5f, 0.5f);
                if (!stack.isEmpty() && !creative) {
                    player.getCooldowns().addCooldown(stack.getItem(), GAGConfig.hearthstone.cooldown());
                }
            } else {
                player.sendSystemMessage((Component)this.getTranslation(Tooltips.FAIL, "too_weak", new Object[0]));
                level.playSound(null, player.blockPosition(), (SoundEvent)GAGRegistry.TELEPORT_FAIL.value(), SoundSource.PLAYERS, 0.6f, 1.0f);
            }
        } else {
            player.sendSystemMessage((Component)this.getTranslation(Tooltips.FAIL, "too_weak", new Object[0]));
            level.playSound(null, player.blockPosition(), (SoundEvent)GAGRegistry.TELEPORT_FAIL.value(), SoundSource.PLAYERS, 0.6f, 1.0f);
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(this.getTranslation(Tooltips.MAIN, "info", new Object[0]), Tooltips.EXTRA.apply(Component.translatable((String)"info.gag.supports_unbreaking"))));
    }

    public Component getTargetText(Player player, ItemStack stack) {
        return this.getTranslation(Tooltips.INFO, "target.bound", this.getTranslation(Tooltips.SUCCESS, "target.respawn", new Object[0]));
    }

    @Override
    public void getHoldingTooltip(Player player, ItemStack stack, TooltipSink sink) {
        sink.acceptText(stack.getHoverName());
        sink.acceptText(this.getTargetText(player, stack));
    }

    @Override
    public void getUsingTooltip(Player player, ItemStack stack, int useTicks, TooltipSink sink) {
        sink.acceptText(stack.getHoverName());
        sink.acceptText(this.getTargetText(player, stack));
        int totalUseTicks = this.getUseDuration(stack, (LivingEntity)player);
        useTicks = Math.min(useTicks, totalUseTicks);
        Component warmupText = Tooltips.asStyledValue(useTicks, totalUseTicks, String.format("%.2f", (double)(totalUseTicks - useTicks) / 20.0));
        sink.acceptText((Component)this.getTranslation(Tooltips.MAIN, "warmup", warmupText));
    }

    protected MutableComponent getTranslation(TooltipStyle style, String key, Object ... args) {
        return style.lang("item.gag.hearthstone." + key, args);
    }

    protected MutableComponent getTranslation(String key, Object ... args) {
        return Component.translatable((String)("item.gag.hearthstone." + key), (Object[])args);
    }
}

