/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.menu;

import java.util.Objects;
import ky.someone.mods.gag.GAGRegistry;
import ky.someone.mods.gag.item.PigmentJarItem;
import ky.someone.mods.gag.item.data.Pigment;
import ky.someone.mods.gag.menu.BasicMenu;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class LabelingMenu
extends BasicMenu {
    protected final Player player;
    protected final Container input = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            LabelingMenu.this.slotsChanged((Container)this);
        }
    };
    public final ResultContainer output = new ResultContainer();
    private String name = "";
    private boolean didApplyPigment = false;

    protected LabelingMenu(@Nullable MenuType<?> menuType, int id, Inventory inventory, Player player) {
        super(menuType, id, inventory);
        this.player = player;
        this.addSlot(new Slot(this.input, 0, 77, 42));
        this.addSlot(new Slot(this, this.input, 1, 26, 42){

            public boolean mayPlace(ItemStack stack) {
                return PigmentJarItem.isNonEmptyJar(stack);
            }

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot((Container)this.output, 2, 135, 42){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                return true;
            }

            public void onTake(Player player, ItemStack stack) {
                boolean wasPigmentApplied = LabelingMenu.this.didApplyPigment;
                player.playNotifySound(SoundEvents.ANVIL_USE, player.getSoundSource(), 0.5f, 2.0f);
                LabelingMenu.this.input.setItem(0, ItemStack.EMPTY);
                ItemStack pigmentJar = LabelingMenu.this.input.getItem(1);
                if (PigmentJarItem.isNonEmptyJar(pigmentJar) && wasPigmentApplied) {
                    player.playNotifySound(SoundEvents.BREWING_STAND_BREW, player.getSoundSource(), 0.75f, 1.5f);
                    if (!player.getAbilities().instabuild) {
                        Pigment pigment = Objects.requireNonNull(PigmentJarItem.getPigment(pigmentJar));
                        LabelingMenu.this.input.setItem(1, pigment.withAmount(pigment.amount() - 1).asJar());
                    }
                }
            }
        });
        this.addPlayerSlots(inventory, 8, 84, true);
    }

    public LabelingMenu(int i, Inventory inventory) {
        this(GAGRegistry.LABELING_MENU, i, inventory, inventory.player);
    }

    @Override
    public int getNonPlayerSlots() {
        return 3;
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack ret = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            ret = stackInSlot.copy();
            switch (index) {
                case 0: 
                case 1: {
                    if (this.moveItemStackTo(stackInSlot, 3, this.slots.size(), false)) break;
                    return ItemStack.EMPTY;
                }
                case 2: {
                    if (!this.moveItemStackTo(stackInSlot, 3, this.slots.size(), true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(stackInSlot, ret);
                    break;
                }
                default: {
                    if (PigmentJarItem.isNonEmptyJar(stackInSlot) && this.input.getItem(1).isEmpty()) {
                        this.input.setItem(1, stackInSlot.split(1));
                        break;
                    }
                    if (this.moveItemStackTo(stackInSlot, 0, 1, false)) break;
                    return ItemStack.EMPTY;
                }
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == ret.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return ret;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.input);
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        if (container == this.input) {
            this.updateOutput();
        }
    }

    public void setName(String name) {
        this.name = name;
        this.updateOutput();
    }

    private void updateOutput() {
        this.didApplyPigment = false;
        ItemStack inputStack = this.input.getItem(0);
        if (inputStack.isEmpty()) {
            this.output.setItem(0, ItemStack.EMPTY);
        } else {
            ItemStack ret = inputStack.copy();
            if (StringUtils.isBlank((CharSequence)this.name)) {
                if (inputStack.has(DataComponents.CUSTOM_NAME)) {
                    ret.remove(DataComponents.CUSTOM_NAME);
                }
            } else {
                Component inputName = inputStack.getHoverName();
                if (!this.name.equals(inputName.getString())) {
                    ret.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.name).withStyle(this::applyPigment));
                } else {
                    TextColor inputColor = inputName.getStyle().getColor();
                    ItemStack pigmentJar = this.input.getItem(1);
                    if (PigmentJarItem.isNonEmptyJar(pigmentJar) && (inputColor == null || inputColor.getValue() != PigmentJarItem.getPigment(pigmentJar).rgb())) {
                        ret.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.name).withStyle(this::applyPigment));
                    }
                }
            }
            this.output.setItem(0, ret);
            this.broadcastChanges();
        }
    }

    private Style applyPigment(Style input) {
        int color = PigmentJarItem.getPigment(this.input.getItem(1)).rgb();
        if (color != -1) {
            this.didApplyPigment = true;
            return input.withColor(color).withItalic(Boolean.valueOf(false));
        }
        this.didApplyPigment = false;
        return input;
    }
}

