/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="gaze", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue DISABLE_GAZE_RITES = BUILDER.comment("Whether to disable Gaze rites entirely.").define("disableGazeRites", false);
    private static final ModConfigSpec.BooleanValue DO_VILLAGER_UMBRALS_ON_SERVER = BUILDER.comment("Whether to allow Villagers to drop Umbral Spirits on a multiplayer server. Singleplayer is always allowed.").define("doVillagerUmbralsOnServer", true);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> UMBRAL_DROP_ENTITIES = BUILDER.comment("List of entity IDs (e.g., 'minecraft:villager') that can drop Umbral Spirits when killed with a Veil Dagger. Players are always on this list.").defineListAllowEmpty("umbralDropEntities", List.of("minecraft:villager"), obj -> obj instanceof String);
    private static final ModConfigSpec.DoubleValue UMBRAL_DROP_CHANCE = BUILDER.comment("Chance (0.0 to 1.0) for configured entities to drop Umbral Spirits when killed with a Veil Dagger. It's always 100% for players.").defineInRange("umbralDropChance", 0.1, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue ENCROACHING_MALICE_INTEGRITY_MULTIPLIER = BUILDER.comment("How much Soul Ward Integrity for a single Armour Toughness point").defineInRange("integrityRatio", 5.0, 1.0, 10.0);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> HEALING_CONVERSION_ATTRIBUTES = BUILDER.comment("List of healing-related attribute IDs that should convert into Soul Ward Recovery Rate if present. Example: ['apothic_attributes:healing_received','othermod:attr_name'] (Options other than apotic haven't been tested)").defineListAllowEmpty("healingConversionAttributes", List.of("apothic_attributes:healing_received"), obj -> {
        String s;
        return obj instanceof String && (s = (String)obj).contains(":");
    });
    private static final ModConfigSpec.BooleanValue FARMABLE_UMBRALS = BUILDER.comment("If mobs holding Veil's Edge (e.g Zombies) can trigger umbral drops from configured mobs or players").define("farmUmbrals", true);
    private static final ModConfigSpec.BooleanValue FANCY_PARTICLES = BUILDER.comment("Whether to do fancy particles for the Gaze addon (this is NOT currently a client-side option)").define("fancyParticles", true);
    private static final ModConfigSpec.BooleanValue BESTIARY = BUILDER.comment("Bestiary entries require kills to be visible (requires statistics to be opened to reveal entries)").define("bestiary", true);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean mobsDropUmbralsOnServer;
    public static boolean disableGazeRites;
    public static boolean farmUmbrals;
    public static boolean fancyParticles;
    public static List<String> umbralDropEntities;
    public static double umbralDropChance;
    public static double integrityRatio;
    public static List<? extends String> extraHealingAttributeId;
    public static boolean bestiary;

    public static Map<ResourceLocation, Double> getHealingConversionAttributes() {
        HashMap<ResourceLocation, Double> map = new HashMap<ResourceLocation, Double>();
        for (String entry : (List)HEALING_CONVERSION_ATTRIBUTES.get()) {
            try {
                ResourceLocation id;
                int lastColon = entry.lastIndexOf(58);
                if (lastColon <= 0 || (id = ResourceLocation.tryParse((String)entry.trim())) == null) continue;
                map.put(id, 1.0);
            }
            catch (Exception exception) {}
        }
        return map;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        mobsDropUmbralsOnServer = (Boolean)DO_VILLAGER_UMBRALS_ON_SERVER.get();
        disableGazeRites = (Boolean)DISABLE_GAZE_RITES.get();
        umbralDropEntities = new ArrayList<String>((Collection)UMBRAL_DROP_ENTITIES.get());
        umbralDropChance = (Double)UMBRAL_DROP_CHANCE.get();
        integrityRatio = (Double)ENCROACHING_MALICE_INTEGRITY_MULTIPLIER.get();
        farmUmbrals = (Boolean)FARMABLE_UMBRALS.get();
        fancyParticles = (Boolean)FANCY_PARTICLES.get();
        bestiary = (Boolean)BESTIARY.get();
        extraHealingAttributeId = (List)HEALING_CONVERSION_ATTRIBUTES.get();
    }
}

