/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities;

import com.sammy.malum.common.data.component.pouch.SoulwovenPouchContentsComponent;
import com.sammy.malum.common.item.curiosities.pouch.SoulwovenPouchItem;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.strawberry.gaze.registry.GazeDataComponents;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class SpiritChannelPouchItem
extends SoulwovenPouchItem {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public SpiritChannelPouchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        BlockPos dumpPos = (BlockPos)stack.get((DataComponentType)GazeDataComponents.DUMP_LOCATION.value());
        ResourceKey dumpDimension = (ResourceKey)stack.get((DataComponentType)GazeDataComponents.DUMP_DIMENSION.value());
        if (player.isShiftKeyDown()) {
            BlockPos pos = player.blockPosition();
            ResourceKey currentDim = level.dimension();
            stack.set((DataComponentType)GazeDataComponents.DUMP_LOCATION.value(), (Object)pos);
            stack.set((DataComponentType)GazeDataComponents.DUMP_DIMENSION.value(), (Object)currentDim);
            player.displayClientMessage((Component)Component.literal((String)("Drop location bound to " + pos.toShortString() + " in dimension " + String.valueOf(currentDim.location()))).withStyle(ChatFormatting.GREEN), true);
            player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        if (contents != null && !contents.isEmpty()) {
            if (dumpPos == null || dumpDimension == null) {
                player.displayClientMessage((Component)Component.literal((String)"No drop location or dimension bound.").withStyle(ChatFormatting.RED), true);
                return InteractionResultHolder.fail((Object)stack);
            }
            if (!level.dimension().equals(dumpDimension)) {
                player.displayClientMessage((Component)Component.literal((String)"Dimensional Interference Detected").withStyle(ChatFormatting.RED), true);
                return InteractionResultHolder.fail((Object)stack);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (serverLevel.hasChunkAt(dumpPos)) {
                    for (ItemStack toDrop : contents.getItems()) {
                        if (toDrop == null || toDrop.isEmpty()) continue;
                        ItemEntity entity = new ItemEntity((Level)serverLevel, (double)dumpPos.getX() + 0.5, (double)(dumpPos.getY() + 1), (double)dumpPos.getZ() + 0.5, toDrop.copy());
                        serverLevel.addFreshEntity((Entity)entity);
                    }
                    stack.set((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
                    player.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 1.0f, 1.0f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    player.getCooldowns().addCooldown((Item)this, 200);
                    return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
                }
                player.displayClientMessage((Component)Component.literal((String)"Target chunk not loaded.").withStyle(ChatFormatting.RED), true);
                return InteractionResultHolder.fail((Object)stack);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static float getFullnessDisplay(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return contents.weight().floatValue();
    }

    public boolean isBarVisible(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return contents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)contents.weight(), (int)12), 13);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get((Supplier)MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null) {
            int fullness = Mth.mulAndTruncate((Fraction)contents.weight(), (int)128);
            tooltip.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{fullness, 256}).withStyle(ChatFormatting.GRAY));
        }
        BlockPos pos = (BlockPos)stack.get((DataComponentType)GazeDataComponents.DUMP_LOCATION.value());
        ResourceKey dim = (ResourceKey)stack.get((DataComponentType)GazeDataComponents.DUMP_DIMENSION.value());
        if (pos != null && dim != null) {
            tooltip.add((Component)Component.literal((String)("Channel Egress: " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + " in " + String.valueOf(dim.location()))).withStyle(ChatFormatting.GRAY));
        }
    }
}

