/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.HydroponicBedConfig;
import com.buuz135.industrial.item.HydroponicSimulationProcessorItem;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.IFAttachments;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.apihandlers.plant.TreePlantRecollectable;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.SpecialPlantable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class HydroponicBedTile
extends IndustrialWorkingTile<HydroponicBedTile> {
    @Save
    private SidedFluidTankComponent<HydroponicBedTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", 1000, 43, 20, 0).setColor(DyeColor.BLUE).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)Fluids.WATER) || fluidStack.getFluid().isSame((Fluid)Fluids.LAVA));
    @Save
    private SidedFluidTankComponent<HydroponicBedTile> ether;
    @Save
    private ProgressBarComponent<HydroponicBedTile> etherBuffer;
    @Save
    private SidedInventoryComponent<HydroponicBedTile> output;
    @Save
    private SidedInventoryComponent<HydroponicBedTile> simulation_slot;
    private PlantRecollectable cachedRecollectable = null;
    private int errorAttempts = 0;

    public HydroponicBedTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.HYDROPONIC_BED, HydroponicBedConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.water);
        this.ether = (SidedFluidTankComponent)new SidedFluidTankComponent("ether", 10, 43, 57, 1).setColor(DyeColor.CYAN).setTankType(FluidTankComponent.Type.SMALL).setTankAction(FluidTankComponent.Action.FILL).setValidator(fluidStack -> fluidStack.getFluid().isSame((Fluid)ModuleCore.ETHER.getSourceFluid().get()));
        this.addTank(this.ether);
        this.etherBuffer = new ProgressBarComponent(63, 20, 200).setColor(DyeColor.CYAN).setCanReset(hydroponicBedTile -> false);
        this.addProgressBar(this.etherBuffer);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 79, 22, 15, 2).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
        this.simulation_slot = (SidedInventoryComponent)new SidedInventoryComponent("simulation", 106, 80, 1, 3).setColor(DyeColor.LIME).setInputFilter((stack, integer) -> stack.getItem().equals(ModuleAgricultureHusbandry.HYDROPONIC_SIMULATION_PROCESSOR.get())).setOutputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.simulation_slot);
    }

    public static boolean tryToHarvestAndReplant(Level level, BlockPos up, BlockState state, IItemHandler output, ProgressBarComponent<?> etherBuffer, IndustrialWorkingTile tile, Supplier<PlantRecollectable> plantSupplier, ItemStack simulationOutput) {
        PlantRecollectable cachedRecollectable = plantSupplier.get();
        if (cachedRecollectable != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (cachedRecollectable instanceof TreePlantRecollectable) {
                while (cachedRecollectable.canBeHarvested(level, up, state)) {
                    drops.addAll(cachedRecollectable.doHarvestOperation(level, up, state));
                }
            } else {
                drops.addAll(cachedRecollectable.doHarvestOperation(level, up, state));
            }
            ItemStack planted = ItemStack.EMPTY;
            if (level.isEmptyBlock(up)) {
                for (ItemStack drop : drops) {
                    SpecialPlantable specialPlantable;
                    BlockItem blockItem;
                    Item item;
                    if (!drop.isEmpty() && (item = drop.getItem()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof BushBlock) {
                        BushBlock bushBlock = (BushBlock)item;
                        planted = drop.copyWithCount(1);
                        BlockState blockstate1 = blockItem.getBlock().defaultBlockState();
                        level.setBlockAndUpdate(up, blockstate1);
                        drop.shrink(1);
                        break;
                    }
                    Item item2 = drop.getItem();
                    if (!(item2 instanceof SpecialPlantable) || !(specialPlantable = (SpecialPlantable)item2).canPlacePlantAtPosition(drop, (LevelReader)level, up, null)) continue;
                    planted = drop.copyWithCount(1);
                    specialPlantable.spawnPlantAtPosition(drop, (LevelAccessor)level, up, null);
                    drop.shrink(1);
                    break;
                }
            }
            if (planted.isEmpty()) {
                planted = cachedRecollectable.getSeedDrop(level, up, state);
            }
            if (!planted.is(IndustrialTags.Items.HYDROPONIC_SIMULATION_BLACKLIST) && !simulationOutput.isEmpty() && simulationOutput.getItem() instanceof HydroponicSimulationProcessorItem) {
                HydroponicSimulationProcessorItem.Simulation sim = new HydroponicSimulationProcessorItem.Simulation((CompoundTag)simulationOutput.get(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR));
                sim.acceptExecution(planted, drops);
                simulationOutput.set(IFAttachments.HYDROPONIC_SIMULATION_PROCESSOR, (Object)sim.toNBT((HolderLookup.Provider)level.registryAccess()));
            }
            drops.forEach(stack -> ItemHandlerHelper.insertItem((IItemHandler)output, (ItemStack)stack, (boolean)false));
            if (tile instanceof IndustrialAreaWorkingTile && cachedRecollectable.shouldCheckNextPlant(level, up, level.getBlockState(up))) {
                ((IndustrialAreaWorkingTile)tile).increasePointer();
            }
            etherBuffer.setProgress(etherBuffer.getProgress() - 1);
            return true;
        }
        return false;
    }

    private void findRecollectable(Level level, BlockPos up, BlockState state) {
        Optional<PlantRecollectable> optional = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.stream().filter(plantRecollectable -> plantRecollectable.canBeHarvested(level, up, state)).findFirst();
        if (optional.isPresent()) {
            this.cachedRecollectable = optional.get();
        }
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.etherBuffer.getProgress() <= 0 && this.ether.getFluidAmount() > 0) {
            this.ether.drainForced(1, IFluidHandler.FluidAction.EXECUTE);
            this.etherBuffer.setProgress(this.etherBuffer.getMaxProgress());
        }
        if (this.hasEnergy(1000)) {
            BlockPos up = this.worldPosition.above();
            BlockState state = this.level.getBlockState(up);
            Supplier<PlantRecollectable> plantRecollectableSupplier = () -> {
                if (this.errorAttempts >= 15) {
                    this.findRecollectable(this.level, up, state);
                    this.errorAttempts = 0;
                }
                if (this.cachedRecollectable == null) {
                    this.findRecollectable(this.level, up, state);
                } else if (this.cachedRecollectable != null && !this.cachedRecollectable.canBeHarvested(this.level, up, state)) {
                    ++this.errorAttempts;
                    return null;
                }
                return this.cachedRecollectable;
            };
            Block block = state.getBlock();
            if (!this.level.isEmptyBlock(up) && this.water.getFluidAmount() >= 10) {
                if (state.getBlock() instanceof BonemealableBlock) {
                    BonemealableBlock growable = (BonemealableBlock)this.level.getBlockState(up).getBlock();
                    if (growable.isValidBonemealTarget((LevelReader)this.level, up, this.level.getBlockState(up)) || state.getBlock() instanceof StemBlock) {
                        if (this.etherBuffer.getProgress() > 0) {
                            growable.performBonemeal((ServerLevel)this.level, this.level.random, up, this.level.getBlockState(up));
                            this.etherBuffer.setProgress(this.etherBuffer.getProgress() - 1);
                        } else {
                            for (int i = 0; i < 4; ++i) {
                                this.level.getBlockState(up).randomTick((ServerLevel)this.level, up, this.level.random);
                            }
                        }
                        this.water.drainForced(10, IFluidHandler.FluidAction.EXECUTE);
                        return new IndustrialWorkingTile.WorkAction(this, 1.0f, HydroponicBedConfig.powerPerOperation);
                    }
                    if (this.etherBuffer.getProgress() > 0) {
                        HydroponicBedTile.tryToHarvestAndReplant(this.level, up, state, this.output, this.etherBuffer, this, plantRecollectableSupplier, this.simulation_slot.getStackInSlot(0));
                        return new IndustrialWorkingTile.WorkAction(this, 1.0f, HydroponicBedConfig.powerPerOperation);
                    }
                } else {
                    if (!HydroponicBedTile.tryToHarvestAndReplant(this.level, up, state, this.output, this.etherBuffer, this, plantRecollectableSupplier, this.simulation_slot.getStackInSlot(0))) {
                        if (this.etherBuffer.getProgress() > 0) {
                            for (int i = 0; i < 10; ++i) {
                                this.level.getBlockState(up).randomTick((ServerLevel)this.level, up, this.level.random);
                            }
                            this.etherBuffer.setProgress(this.etherBuffer.getProgress() - 1);
                        } else {
                            for (int i = 0; i < 4; ++i) {
                                this.level.getBlockState(up).randomTick((ServerLevel)this.level, up, this.level.random);
                            }
                        }
                        this.water.drainForced(10, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return new IndustrialWorkingTile.WorkAction(this, 1.0f, HydroponicBedConfig.powerPerOperation);
                }
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    public SidedFluidTankComponent<HydroponicBedTile> getWater() {
        return this.water;
    }

    public SidedFluidTankComponent<HydroponicBedTile> getEther() {
        return this.ether;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, HydroponicBedTile blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.level.getGameTime() % 5L == 0L) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockEntity tile = level.getBlockEntity(this.worldPosition.relative(direction));
                if (!(tile instanceof HydroponicBedTile)) continue;
                int difference = this.water.getFluidAmount() - ((HydroponicBedTile)tile).getWater().getFluidAmount();
                if (difference > 0 && (this.water.getFluid().is(((HydroponicBedTile)tile).getWater().getFluid().getFluid()) || ((HydroponicBedTile)tile).getWater().isEmpty())) {
                    difference = difference <= 25 ? (difference /= 2) : 25;
                    if (this.water.getFluidAmount() >= difference) {
                        this.water.drainForced(((HydroponicBedTile)tile).getWater().fill(new FluidStack((Fluid)Fluids.WATER, this.water.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.ether.getFluidAmount() - ((HydroponicBedTile)tile).getEther().getFluidAmount()) > 0) {
                    difference = 1;
                    if (this.ether.getFluidAmount() >= difference) {
                        this.ether.drainForced(((HydroponicBedTile)tile).getEther().fill(new FluidStack((Fluid)ModuleCore.ETHER.getSourceFluid().get(), this.ether.drainForced(difference, IFluidHandler.FluidAction.SIMULATE).getAmount()), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                if ((difference = this.getEnergyStorage().getEnergyStored() - ((HydroponicBedTile)tile).getEnergyStorage().getEnergyStored()) <= 0) continue;
                if (difference <= 1000 && difference > 1) {
                    difference /= 2;
                }
                if (difference > 1000) {
                    difference = 1000;
                }
                if (this.getEnergyStorage().getEnergyStored() < difference) continue;
                this.getEnergyStorage().extractEnergy(((HydroponicBedTile)tile).getEnergyStorage().receiveEnergy(difference, false), false);
            }
        }
    }

    @Override
    public int getMaxProgress() {
        return HydroponicBedConfig.maxProgress;
    }

    @Nonnull
    public HydroponicBedTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<HydroponicBedTile> createEnergyStorage() {
        return new EnergyStorageComponent(HydroponicBedConfig.maxStoredPower, 10, 20);
    }
}

