/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.block.AdvancedRedstoneTorchBlock;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.AdvancedRedstoneTorchBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u001e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/AdvancedRedstoneWallTorchBlock;", "Lnet/minecraft/world/level/block/RedstoneWallTorchBlock;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getSignal", "", "blockState", "blockAccess", "Lnet/minecraft/world/level/BlockGetter;", "side", "Lnet/minecraft/core/Direction;", "animateTick", "", "random", "Lnet/minecraft/util/RandomSource;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "irregular-implements-1.21.1"})
public final class AdvancedRedstoneWallTorchBlock
extends RedstoneWallTorchBlock
implements EntityBlock {
    public AdvancedRedstoneWallTorchBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.REDSTONE_WALL_TORCH)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            player.openMenu((MenuProvider)blockEntity);
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.useWithoutItem(state, level, pos, player, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    protected int getSignal(@NotNull BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockAccess, (String)"blockAccess");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (side == blockState.getValue((Property)RedstoneWallTorchBlock.FACING)) {
            return 0;
        }
        BlockEntity blockEntity = blockAccess.getBlockEntity(pos);
        if (blockEntity instanceof AdvancedRedstoneTorchBlockEntity) {
            Boolean isLit = (Boolean)blockState.getValue((Property)RedstoneWallTorchBlock.LIT);
            AdvancedRedstoneTorchBlockEntity advancedRedstoneTorchBlockEntity = (AdvancedRedstoneTorchBlockEntity)blockEntity;
            Intrinsics.checkNotNull((Object)isLit);
            return advancedRedstoneTorchBlockEntity.getStrength(isLit);
        }
        return super.getSignal(blockState, blockAccess, pos, side);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Vector3f color = (Boolean)state.getValue((Property)RedstoneTorchBlock.LIT) != false ? AdvancedRedstoneTorchBlock.Companion.getRED_COLOR() : AdvancedRedstoneTorchBlock.Companion.getGREEN_COLOR();
        Direction dir = ((Direction)state.getValue((Property)RedstoneWallTorchBlock.FACING)).getOpposite();
        double scaling = 0.27;
        double x = (double)pos.getX() + AaronExtensions.INSTANCE.nextRange(random, 0.4, 0.6) + scaling * (double)dir.getStepX();
        double y = (double)pos.getY() + AaronExtensions.INSTANCE.nextRange(random, 0.6, 0.8) + 0.22;
        double z = (double)pos.getZ() + AaronExtensions.INSTANCE.nextRange(random, 0.4, 0.6) + scaling * (double)dir.getStepZ();
        level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), x, y, z, 0.0, 0.0, 0.0);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new AdvancedRedstoneTorchBlockEntity(pos, state);
    }
}

