/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J8\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0018H\u0014J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0014J(\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J(\u0010$\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0014\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/AnalogEmitterBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "oldState", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "canConnectRedstone", "", "state", "Lnet/minecraft/world/level/BlockGetter;", "direction", "Lnet/minecraft/core/Direction;", "neighborChanged", "block", "fromPos", "isMoving", "isSignalSource", "getDirectSignal", "", "getSignal", "Companion", "irregular-implements-1.21.1"})
public final class AnalogEmitterBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DirectionProperty FACING;
    @NotNull
    private static final BooleanProperty ENABLED;
    @NotNull
    private static final IntegerProperty POWER;

    public AnalogEmitterBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.TARGET)).isRedstoneConductor(Blocks::never));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{FACING, ENABLED, POWER};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState oldState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!player.getItemInHand(player.getUsedItemHand()).isEmpty()) {
            return InteractionResult.PASS;
        }
        int newPower = ((Number)((Object)oldState.getValue((Property)POWER))).intValue() + (player.isSecondaryUseActive() ? -1 : 1);
        MutableComponent component = ModLanguageProvider.Companion.toComponent(String.valueOf(newPower &= 0xF), new Object[0]).withStyle(ChatFormatting.RED);
        Intrinsics.checkNotNull((Object)component);
        AaronExtensions.INSTANCE.status(player, (Component)component);
        BlockState newState = (BlockState)oldState.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower));
        level.setBlockAndUpdate(pos, newState);
        float pitch = 0.5f + (float)newPower / 15.0f * 1.5f;
        level.playSound(null, pos, (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.15f, pitch);
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    protected void neighborChanged(@NotNull BlockState oldState, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        if (level.isClientSide) {
            return;
        }
        Direction facing = (Direction)oldState.getValue((Property)FACING);
        boolean facingSideIsPowered = level.hasSignal(pos.relative(facing), facing.getOpposite());
        BlockState newState = (BlockState)oldState.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(facingSideIsPowered));
        level.setBlockAndUpdate(pos, newState);
    }

    protected boolean isSignalSource(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected int getDirectSignal(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        if (!((Boolean)state.getValue((Property)ENABLED)).booleanValue() || direction == state.getValue((Property)FACING)) {
            return 0;
        }
        Comparable comparable = state.getValue((Property)POWER);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return ((Number)((Object)comparable)).intValue();
    }

    protected int getSignal(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.getDirectSignal(state, level, pos, direction);
    }

    static {
        DirectionProperty directionProperty = BlockStateProperties.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
        BooleanProperty booleanProperty = BlockStateProperties.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"ENABLED");
        ENABLED = booleanProperty;
        IntegerProperty integerProperty = BlockStateProperties.POWER;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"POWER");
        POWER = integerProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/AnalogEmitterBlock$Companion;", "", "<init>", "()V", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "ENABLED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getENABLED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "POWER", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getPOWER", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        @NotNull
        public final BooleanProperty getENABLED() {
            return ENABLED;
        }

        @NotNull
        public final IntegerProperty getPOWER() {
            return POWER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

