/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import com.google.common.collect.ImmutableList;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import dev.aaronhowser.mods.irregular_implements.registry.ModEffects;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\bH\u0014J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J8\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001dH\u0014J \u0010 \u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J(\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\"\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0014\u00a8\u0006'"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/SakanadeBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/neoforged/neoforge/common/IShearable;", "<init>", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "canSurvive", "", "Lnet/minecraft/world/level/LevelReader;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "getStateForPlacement", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "canBeReplaced", "useContext", "propagatesSkylightDown", "getCollisionShape", "entityInside", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSakanadeBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SakanadeBlock.kt\ndev/aaronhowser/mods/irregular_implements/block/SakanadeBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1285#2,2:222\n1299#2,4:224\n*S KotlinDebug\n*F\n+ 1 SakanadeBlock.kt\ndev/aaronhowser/mods/irregular_implements/block/SakanadeBlock\n*L\n48#1:222,2\n48#1:224,4\n*E\n"})
public final class SakanadeBlock
extends Block
implements IShearable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE_UP;
    @NotNull
    private static final VoxelShape SHAPE_WEST;
    @NotNull
    private static final VoxelShape SHAPE_EAST;
    @NotNull
    private static final VoxelShape SHAPE_NORTH;
    @NotNull
    private static final VoxelShape SHAPE_SOUTH;
    @NotNull
    private static final VoxelShape SHAPE_DOWN;
    @NotNull
    private static final BooleanProperty NORTH;
    @NotNull
    private static final BooleanProperty EAST;
    @NotNull
    private static final BooleanProperty SOUTH;
    @NotNull
    private static final BooleanProperty WEST;
    @NotNull
    private static final BooleanProperty UP;
    @NotNull
    private static final BooleanProperty DOWN;
    @NotNull
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION;
    private static final float SHAPE_OFFSET = 1.0f;
    private static Map<BlockState, ? extends VoxelShape> shapesCache;

    /*
     * WARNING - void declaration
     */
    public SakanadeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.VINE)).isViewBlocking(Blocks::never).replaceable());
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        ImmutableList immutableList = this.stateDefinition.getPossibleStates();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getPossibleStates(...)");
        Iterable iterable = (Iterable)immutableList;
        Companion companion = Companion;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void var5_5 = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void p0;
            BlockState blockState = (BlockState)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            VoxelShape voxelShape = companion.calculateShape((BlockState)p0);
            map.put(t, voxelShape);
        }
        shapesCache = destination$iv$iv;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<BlockState, ? extends VoxelShape> map = shapesCache;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shapesCache");
            map = null;
        }
        if ((voxelShape = map.get(state)) == null) {
            voxelShape = SakanadeBlock.Companion.calculateShape(state);
        }
        return voxelShape;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return SakanadeBlock.Companion.hasFaces(SakanadeBlock.Companion.getUpdatedState(state, (BlockGetter)level, pos));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        BlockState newState = SakanadeBlock.Companion.getUpdatedState(state, (BlockGetter)level, pos);
        if (!SakanadeBlock.Companion.hasFaces(newState)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            blockState = newState;
        }
        return blockState;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        boolean clickedThis = clickedState.is((Block)this);
        BlockState stateToPlace = clickedThis ? clickedState : this.defaultBlockState();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])context.getNearestLookingDirections());
        while (iterator.hasNext()) {
            BooleanProperty property;
            boolean alreadyHasProperty;
            Direction direction = (Direction)iterator.next();
            if (PROPERTY_BY_DIRECTION.get(direction) == null || (alreadyHasProperty = clickedThis && (Boolean)clickedState.getValue((Property)property) != false)) continue;
            Intrinsics.checkNotNull((Object)level);
            BlockGetter blockGetter = (BlockGetter)level;
            BlockPos blockPos = clickedPos.relative(direction);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
            Intrinsics.checkNotNull((Object)direction);
            if (!Companion.isAcceptableNeighbour(blockGetter, blockPos, direction)) continue;
            return (BlockState)stateToPlace.setValue((Property)property, (Comparable)Boolean.valueOf(true));
        }
        return clickedThis ? stateToPlace : null;
    }

    protected boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext useContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)useContext, (String)"useContext");
        Level level = useContext.getLevel();
        BlockPos clickedPos = useContext.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.is((Block)this)) {
            Intrinsics.checkNotNull((Object)clickedState);
            bl = SakanadeBlock.Companion.countFaces(clickedState) < PROPERTY_BY_DIRECTION.size();
        } else {
            bl = super.canBeReplaced(state, useContext);
        }
        return bl;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.empty();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
        return voxelShape;
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance((Holder)ModEffects.COLLAPSE, 160));
        }
    }

    @JvmStatic
    public static final void addToMushroom(@NotNull LevelAccessor level, @NotNull BlockPos origin, @NotNull HugeMushroomFeatureConfiguration config, @NotNull BlockPos.MutableBlockPos mutablePos) {
        Companion.addToMushroom(level, origin, config, mutablePos);
    }

    static {
        VoxelShape voxelShape = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE_UP = voxelShape;
        VoxelShape voxelShape2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        SHAPE_WEST = voxelShape2;
        VoxelShape voxelShape3 = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        SHAPE_EAST = voxelShape3;
        VoxelShape voxelShape4 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"box(...)");
        SHAPE_NORTH = voxelShape4;
        VoxelShape voxelShape5 = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"box(...)");
        SHAPE_SOUTH = voxelShape5;
        VoxelShape voxelShape6 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape6, (String)"box(...)");
        SHAPE_DOWN = voxelShape6;
        BooleanProperty booleanProperty = BlockStateProperties.NORTH;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"NORTH");
        NORTH = booleanProperty;
        BooleanProperty booleanProperty2 = BlockStateProperties.EAST;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty2, (String)"EAST");
        EAST = booleanProperty2;
        BooleanProperty booleanProperty3 = BlockStateProperties.SOUTH;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty3, (String)"SOUTH");
        SOUTH = booleanProperty3;
        BooleanProperty booleanProperty4 = BlockStateProperties.WEST;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty4, (String)"WEST");
        WEST = booleanProperty4;
        BooleanProperty booleanProperty5 = BlockStateProperties.UP;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty5, (String)"UP");
        UP = booleanProperty5;
        BooleanProperty booleanProperty6 = BlockStateProperties.DOWN;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty6, (String)"DOWN");
        DOWN = booleanProperty6;
        Map map = PipeBlock.PROPERTY_BY_DIRECTION;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"PROPERTY_BY_DIRECTION");
        PROPERTY_BY_DIRECTION = map;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u000202H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00104\u001a\u000202H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00104\u001a\u000202H\u0002J\u001e\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020,J \u0010>\u001a\u0002022\u0006\u00104\u001a\u0002022\u0006\u0010\u0006\u001a\u00020;2\u0006\u0010?\u001a\u00020\tH\u0002J \u0010@\u001a\u0002082\u0006\u0010\u0006\u001a\u00020;2\u0006\u0010?\u001a\u00020\t2\u0006\u0010A\u001a\u00020,H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u0011\u0010$\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001fR\u0011\u0010&\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001fR\u0011\u0010(\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001fR\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001d0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u000f0+X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/SakanadeBlock$Companion;", "", "<init>", "()V", "addToMushroom", "", "level", "Lnet/minecraft/world/level/LevelAccessor;", "origin", "Lnet/minecraft/core/BlockPos;", "config", "Lnet/minecraft/world/level/levelgen/feature/configurations/HugeMushroomFeatureConfiguration;", "mutablePos", "Lnet/minecraft/core/BlockPos$MutableBlockPos;", "SHAPE_UP", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE_UP", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_WEST", "getSHAPE_WEST", "SHAPE_EAST", "getSHAPE_EAST", "SHAPE_NORTH", "getSHAPE_NORTH", "SHAPE_SOUTH", "getSHAPE_SOUTH", "SHAPE_DOWN", "getSHAPE_DOWN", "NORTH", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getNORTH", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "EAST", "getEAST", "SOUTH", "getSOUTH", "WEST", "getWEST", "UP", "getUP", "DOWN", "getDOWN", "PROPERTY_BY_DIRECTION", "", "Lnet/minecraft/core/Direction;", "getPROPERTY_BY_DIRECTION", "()Ljava/util/Map;", "SHAPE_OFFSET", "", "shapesCache", "Lnet/minecraft/world/level/block/state/BlockState;", "calculateShape", "state", "countFaces", "", "hasFaces", "", "isAcceptableNeighbour", "blockReader", "Lnet/minecraft/world/level/BlockGetter;", "neighborPos", "attachedFace", "getUpdatedState", "pos", "canSupportAtFace", "direction", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void addToMushroom(@NotNull LevelAccessor level, @NotNull BlockPos origin, @NotNull HugeMushroomFeatureConfiguration config, @NotNull BlockPos.MutableBlockPos mutablePos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)mutablePos, (String)"mutablePos");
            if (mutablePos.getX() == origin.getX() && mutablePos.getZ() == origin.getZ()) {
                return;
            }
            if (level.getBlockState(mutablePos.below()).canBeReplaced()) {
                level.setBlock(mutablePos.below(), (BlockState)((SakanadeBlock)((Object)ModBlocks.INSTANCE.getSAKANADE_SPORES().get())).defaultBlockState().setValue((Property)this.getUP(), (Comparable)Boolean.valueOf(true)), 3);
            }
        }

        @NotNull
        public final VoxelShape getSHAPE_UP() {
            return SHAPE_UP;
        }

        @NotNull
        public final VoxelShape getSHAPE_WEST() {
            return SHAPE_WEST;
        }

        @NotNull
        public final VoxelShape getSHAPE_EAST() {
            return SHAPE_EAST;
        }

        @NotNull
        public final VoxelShape getSHAPE_NORTH() {
            return SHAPE_NORTH;
        }

        @NotNull
        public final VoxelShape getSHAPE_SOUTH() {
            return SHAPE_SOUTH;
        }

        @NotNull
        public final VoxelShape getSHAPE_DOWN() {
            return SHAPE_DOWN;
        }

        @NotNull
        public final BooleanProperty getNORTH() {
            return NORTH;
        }

        @NotNull
        public final BooleanProperty getEAST() {
            return EAST;
        }

        @NotNull
        public final BooleanProperty getSOUTH() {
            return SOUTH;
        }

        @NotNull
        public final BooleanProperty getWEST() {
            return WEST;
        }

        @NotNull
        public final BooleanProperty getUP() {
            return UP;
        }

        @NotNull
        public final BooleanProperty getDOWN() {
            return DOWN;
        }

        @NotNull
        public final Map<Direction, BooleanProperty> getPROPERTY_BY_DIRECTION() {
            return PROPERTY_BY_DIRECTION;
        }

        private final VoxelShape calculateShape(BlockState state) {
            VoxelShape voxelShape;
            VoxelShape voxelShape2 = Shapes.empty();
            if (((Boolean)state.getValue((Property)this.getUP())).booleanValue()) {
                voxelShape2 = this.getSHAPE_UP();
            }
            if (((Boolean)state.getValue((Property)this.getNORTH())).booleanValue()) {
                voxelShape2 = Shapes.or((VoxelShape)voxelShape2, (VoxelShape)this.getSHAPE_NORTH());
            }
            if (((Boolean)state.getValue((Property)this.getSOUTH())).booleanValue()) {
                voxelShape2 = Shapes.or((VoxelShape)voxelShape2, (VoxelShape)this.getSHAPE_SOUTH());
            }
            if (((Boolean)state.getValue((Property)this.getEAST())).booleanValue()) {
                voxelShape2 = Shapes.or((VoxelShape)voxelShape2, (VoxelShape)this.getSHAPE_EAST());
            }
            if (((Boolean)state.getValue((Property)this.getWEST())).booleanValue()) {
                voxelShape2 = Shapes.or((VoxelShape)voxelShape2, (VoxelShape)this.getSHAPE_WEST());
            }
            if (((Boolean)state.getValue((Property)this.getDOWN())).booleanValue()) {
                voxelShape2 = Shapes.or((VoxelShape)voxelShape2, (VoxelShape)this.getSHAPE_DOWN());
            }
            if (voxelShape2.isEmpty()) {
                VoxelShape voxelShape3 = Shapes.block();
                voxelShape = voxelShape3;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"block(...)");
            } else {
                VoxelShape voxelShape4 = voxelShape2;
                Intrinsics.checkNotNull((Object)voxelShape4);
                voxelShape = voxelShape4;
            }
            return voxelShape;
        }

        private final int countFaces(BlockState state) {
            int count = 0;
            for (Map.Entry<Direction, BooleanProperty> property : this.getPROPERTY_BY_DIRECTION().entrySet()) {
                if (!((Boolean)state.getValue((Property)property.getValue())).booleanValue()) continue;
                ++count;
            }
            return count;
        }

        private final boolean hasFaces(BlockState state) {
            return this.countFaces(state) > 0;
        }

        public final boolean isAcceptableNeighbour(@NotNull BlockGetter blockReader, @NotNull BlockPos neighborPos, @NotNull Direction attachedFace) {
            Intrinsics.checkNotNullParameter((Object)blockReader, (String)"blockReader");
            Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
            Intrinsics.checkNotNullParameter((Object)attachedFace, (String)"attachedFace");
            return MultifaceBlock.canAttachTo((BlockGetter)blockReader, (Direction)attachedFace, (BlockPos)neighborPos, (BlockState)blockReader.getBlockState(neighborPos));
        }

        private final BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos) {
            BlockState blockState = state;
            BlockState tempState = null;
            for (Direction direction : EntriesMappings.entries$0) {
                BooleanProperty property;
                if (this.getPROPERTY_BY_DIRECTION().get(direction) == null || !((Boolean)state.getValue((Property)property)).booleanValue()) continue;
                boolean flag = this.canSupportAtFace(level, pos, direction);
                if (!flag) {
                    if (tempState == null) {
                        tempState = level.getBlockState(pos.above());
                    }
                    BlockState blockState2 = tempState;
                    Intrinsics.checkNotNull(blockState2);
                    flag = blockState2.is((Holder)ModBlocks.INSTANCE.getSAKANADE_SPORES()) && (Boolean)tempState.getValue((Property)property) != false;
                }
                Object object = blockState.setValue((Property)property, (Comparable)Boolean.valueOf(flag));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                blockState = (BlockState)object;
            }
            return blockState;
        }

        private final boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
            BlockPos relative = pos.relative(direction);
            Intrinsics.checkNotNull((Object)relative);
            if (this.isAcceptableNeighbour(level, relative, direction)) {
                return true;
            }
            BooleanProperty booleanProperty = this.getPROPERTY_BY_DIRECTION().get(direction);
            if (booleanProperty == null) {
                return false;
            }
            BooleanProperty property = booleanProperty;
            BlockState state = level.getBlockState(relative);
            return state.is((Holder)ModBlocks.INSTANCE.getSAKANADE_SPORES()) && (Boolean)state.getValue((Property)property) != false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Direction> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
            }
        }
    }
}

