/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import com.mojang.datafixers.util.Pair;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.particle.ColoredFlameParticleOptions;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0002J(\u0010\u001e\u001a\u0004\u0018\u00010\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u0011H\u0002J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020(H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001a\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BiomeRadarBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "antennaValid", "", "biomePos", "biomeStack", "Lnet/minecraft/world/item/ItemStack;", "flameProgress", "", "getBiomeStack", "setBiomeStack", "", "stack", "getBiomePos", "updateAntenna", "checkAntenna", "serverTick", "clientTick", "updateFlameProgress", "spawnParticles", "biomeCache", "", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/biome/Biome;", "locateBiome", "targetBiome", "searchFrom", "level", "Lnet/minecraft/server/level/ServerLevel;", "searchForBiome", "loadAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBiomeRadarBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomeRadarBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/BiomeRadarBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,244:1\n1740#2,3:245\n1563#2:248\n1634#2,3:249\n382#3,7:252\n*S KotlinDebug\n*F\n+ 1 BiomeRadarBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/BiomeRadarBlockEntity\n*L\n52#1:245,3\n106#1:248\n106#1:249,3\n139#1:252,7\n*E\n"})
public final class BiomeRadarBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean antennaValid;
    @Nullable
    private BlockPos biomePos;
    @NotNull
    private ItemStack biomeStack;
    private double flameProgress;
    @NotNull
    private final Map<ResourceKey<Biome>, BlockPos> biomeCache;
    @NotNull
    private static final String ANTENNA_VALID_NBT = "AntennaValid";
    @NotNull
    private static final String BIOME_POS_NBT = "BiomePos";
    @NotNull
    private static final String BIOME_STACK_NBT = "BiomeStack";
    private static final float FLAME_PROGRESS_PER_TICK = 0.01f;
    @NotNull
    private static final List<BlockPos> ANTENNA_RELATIVE_POSITIONS;
    @NotNull
    private static final List<BlockPos> PARTICLE_POINTS;

    public BiomeRadarBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getBIOME_RADAR().get(), pos, blockState);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.biomeStack = itemStack;
        this.biomeCache = new LinkedHashMap();
    }

    @NotNull
    public final ItemStack getBiomeStack() {
        ItemStack itemStack = this.biomeStack.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public final void setBiomeStack(@NotNull ItemStack stack) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            ItemStack itemStack = stack.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            this.biomeStack = itemStack;
            this.searchForBiome();
            this.setChanged();
            Level level = this.level;
            if (level == null) break block0;
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 11);
        }
    }

    @Nullable
    public final BlockPos getBiomePos() {
        return this.biomePos;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAntenna() {
        boolean bl;
        boolean bl2;
        block4: {
            void $this$all$iv;
            Level level = this.level;
            if (level == null) {
                return;
            }
            Level level2 = level;
            Iterable iterable = ANTENNA_RELATIVE_POSITIONS;
            BiomeRadarBlockEntity biomeRadarBlockEntity = this;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BlockPos relPos = (BlockPos)element$iv;
                    boolean bl3 = false;
                    BlockPos checkPos = this.getBlockPos().offset((Vec3i)relPos);
                    BlockState blockState = level2.getBlockState(checkPos);
                    if (blockState.is(Blocks.IRON_BARS)) continue;
                    bl2 = false;
                    break block4;
                }
                bl2 = true;
            }
        }
        biomeRadarBlockEntity.antennaValid = bl = bl2;
    }

    private final void checkAntenna() {
        block2: {
            boolean wasValid = this.antennaValid;
            this.updateAntenna();
            boolean isValid = this.antennaValid;
            if (isValid == wasValid) {
                return;
            }
            if (!isValid) {
                this.biomePos = null;
            }
            this.setChanged();
            Level level = this.level;
            if (level == null) break block2;
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 11);
        }
    }

    private final void serverTick() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (level2.getGameTime() % (long)20 == 0L) {
            this.checkAntenna();
        }
    }

    private final void clientTick() {
        if (!this.antennaValid) {
            return;
        }
        this.updateFlameProgress();
        this.spawnParticles();
    }

    private final void updateFlameProgress() {
        if (!this.antennaValid) {
            this.flameProgress = 0.0;
            return;
        }
        this.flameProgress = this.biomePos != null ? RangesKt.coerceAtMost((double)(this.flameProgress + (double)0.01f), (double)1.0) : RangesKt.coerceAtLeast((double)(this.flameProgress - (double)0.01f), (double)0.0);
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnParticles() {
        Holder holder;
        Vec3 direction;
        void $this$mapTo$iv$iv;
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (level2.getGameTime() % (long)3 != 0L) {
            return;
        }
        Iterable $this$map$iv = PARTICLE_POINTS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BlockPos blockPos = (BlockPos)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.offset((Vec3i)this.getBlockPos()).getBottomCenter().add(0.0, 0.2, 0.0));
        }
        List particlePositions = (List)destination$iv$iv;
        BlockPos biomePos = this.biomePos;
        Vec3 vec3 = direction = biomePos == null ? Vec3.ZERO : this.getBlockPos().getCenter().vectorTo(biomePos.getCenter()).normalize().scale(0.03).scale(this.flameProgress);
        int colorInt = biomePos == null ? 0x333333 : ((holder = (Holder)this.getBiomeStack().get((Supplier)ModDataComponents.INSTANCE.getBIOME())) != null && (holder = (Biome)holder.value()) != null ? holder.getFoliageColor() : 65280);
        Vector3f colorVec = Vec3.fromRGB24((int)colorInt).toVector3f();
        for (Vec3 pos : particlePositions) {
            Intrinsics.checkNotNull((Object)colorVec);
            level2.addParticle((ParticleOptions)new ColoredFlameParticleOptions(colorVec), pos.x, pos.y, pos.z, direction.x, 0.05, direction.z);
        }
    }

    private final BlockPos locateBiome(ResourceKey<Biome> targetBiome, BlockPos searchFrom, ServerLevel level) {
        BlockPos blockPos;
        Map<ResourceKey<Biome>, BlockPos> $this$getOrPut$iv = this.biomeCache;
        boolean $i$f$getOrPut = false;
        BlockPos value$iv = $this$getOrPut$iv.get(targetBiome);
        if (value$iv == null) {
            boolean bl = false;
            Predicate predicate = (Predicate)((com.google.common.base.Predicate)arg_0 -> BiomeRadarBlockEntity.locateBiome$lambda$3$lambda$2(targetBiome, arg_0));
            Object object = ServerConfig.Companion.getCONFIG().getBiomeRadarSearchRadius().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            int n = ((Number)object).intValue();
            Object object2 = ServerConfig.Companion.getCONFIG().getBiomeRadarHorizontalStep().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            int n2 = ((Number)object2).intValue();
            Object object3 = ServerConfig.Companion.getCONFIG().getBiomeRadarVerticalStep().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            Pair pair = level.findClosestBiome3d(predicate, searchFrom, n, n2, ((Number)object3).intValue());
            BlockPos answer$iv = pair != null ? (BlockPos)pair.getFirst() : null;
            $this$getOrPut$iv.put(targetBiome, answer$iv);
            blockPos = answer$iv;
        } else {
            blockPos = value$iv;
        }
        return blockPos;
    }

    private final void searchForBiome() {
        BlockPos pos;
        ResourceKey targetBiomeKey;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Holder holder = (Holder)this.biomeStack.get((Supplier)ModDataComponents.INSTANCE.getBIOME());
        Object object = targetBiomeKey = holder != null ? holder.getKey() : null;
        if (targetBiomeKey == null) {
            v3 = null;
        } else {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            v3 = pos = this.locateBiome((ResourceKey<Biome>)targetBiomeKey, blockPos, level2);
        }
        if (Intrinsics.areEqual(pos, (Object)this.biomePos)) {
            return;
        }
        this.biomePos = pos;
        this.setChanged();
        level2.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 11);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.antennaValid = tag.getBoolean(ANTENNA_VALID_NBT);
        this.biomePos = tag.contains(BIOME_POS_NBT) ? BlockPos.of((long)tag.getLong(BIOME_POS_NBT)) : null;
        ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(BIOME_STACK_NBT));
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"parseOptional(...)");
        this.biomeStack = itemStack;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putBoolean(ANTENNA_VALID_NBT, this.antennaValid);
        tag.put(BIOME_STACK_NBT, this.biomeStack.saveOptional(registries));
        BlockPos bp = this.biomePos;
        if (bp != null) {
            tag.putLong(BIOME_POS_NBT, bp.asLong());
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    private static final boolean locateBiome$lambda$3$lambda$2(ResourceKey $targetBiome, Holder it) {
        return it.is($targetBiome);
    }

    static {
        Object[] objectArray = new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, 2, 0), new BlockPos(1, 2, 0), new BlockPos(-1, 2, 0), new BlockPos(0, 2, 1), new BlockPos(0, 2, -1), new BlockPos(1, 3, 0), new BlockPos(-1, 3, 0), new BlockPos(0, 3, 1), new BlockPos(0, 3, -1)};
        ANTENNA_RELATIVE_POSITIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new BlockPos[]{new BlockPos(1, 4, 0), new BlockPos(-1, 4, 0), new BlockPos(0, 4, 1), new BlockPos(0, 4, -1)};
        PARTICLE_POINTS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BiomeRadarBlockEntity$Companion;", "", "<init>", "()V", "ANTENNA_VALID_NBT", "", "BIOME_POS_NBT", "BIOME_STACK_NBT", "FLAME_PROGRESS_PER_TICK", "", "ANTENNA_RELATIVE_POSITIONS", "", "Lnet/minecraft/core/BlockPos;", "getANTENNA_RELATIVE_POSITIONS", "()Ljava/util/List;", "PARTICLE_POINTS", "getPARTICLE_POINTS", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BiomeRadarBlockEntity;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BlockPos> getANTENNA_RELATIVE_POSITIONS() {
            return ANTENNA_RELATIVE_POSITIONS;
        }

        @NotNull
        public final List<BlockPos> getPARTICLE_POINTS() {
            return PARTICLE_POINTS;
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull BiomeRadarBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                blockEntity.clientTick();
            } else {
                blockEntity.serverTick();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

