/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.PlayerInterfaceBlockEntity;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/block_entity/PlayerInterfaceBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getContext", "()Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "skullModels", "", "Lnet/minecraft/world/level/block/SkullBlock$Type;", "Lnet/minecraft/client/model/SkullModelBase;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "irregular-implements-1.21.1"})
public final class PlayerInterfaceBlockEntityRenderer
implements BlockEntityRenderer<PlayerInterfaceBlockEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    @NotNull
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;

    public PlayerInterfaceBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Map map = SkullBlockRenderer.createSkullRenderers((EntityModelSet)this.context.getModelSet());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSkullRenderers(...)");
        this.skullModels = map;
    }

    @NotNull
    public final BlockEntityRendererProvider.Context getContext() {
        return this.context;
    }

    public void render(@NotNull PlayerInterfaceBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Level level = blockEntity.getLevel();
        boolean spaceAbove = AaronExtensions.INSTANCE.isTrue(level != null ? Boolean.valueOf(level.isEmptyBlock(blockEntity.getBlockPos().above())) : null);
        if (!spaceAbove) {
            return;
        }
        ItemStack skull = blockEntity.getOwnerHead();
        if (skull.isEmpty()) {
            return;
        }
        ResolvableProfile resolvableProfile = (ResolvableProfile)skull.get(DataComponents.PROFILE);
        if (resolvableProfile == null) {
            return;
        }
        ResolvableProfile profile = resolvableProfile;
        SkullModelBase skullModelBase = this.skullModels.get(SkullBlock.Types.PLAYER);
        if (skullModelBase == null) {
            return;
        }
        SkullModelBase model = skullModelBase;
        poseStack.pushPose();
        Player localPlayer = AaronClientUtil.getLocalPlayer();
        if (localPlayer != null) {
            Vec3 deltaPos = blockEntity.getBlockPos().above().getCenter().vectorTo(localPlayer.getEyePosition()).normalize();
            poseStack.translate(0.5, 0.5, 0.5);
            float yaw = (float)Math.atan2(deltaPos.x, deltaPos.z) - (float)Math.PI;
            float pitch = (float)Math.atan2(deltaPos.y, deltaPos.horizontalDistance());
            poseStack.mulPose(Axis.YP.rotation(yaw));
            poseStack.mulPose(Axis.XP.rotation(pitch));
            poseStack.translate(-0.5, -0.5, -0.5);
        }
        poseStack.translate(0.0f, 1.1f, 0.0f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)0xFFFFFF, (SkullModelBase)model, (RenderType)SkullBlockRenderer.getRenderType((SkullBlock.Type)((SkullBlock.Type)SkullBlock.Types.PLAYER), (ResolvableProfile)profile));
        poseStack.popPose();
    }
}

