/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.handler.SpectreEnergyHandler;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\bJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/command/SpectreEnergyCommand;", "", "<init>", "()V", "PLAYER", "", "AMOUNT", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "createSetCommand", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "createGetCommand", "setSpectreEnergy", "", "source", "player", "Lnet/minecraft/server/level/ServerPlayer;", "amount", "getSpectreEnergy", "irregular-implements-1.21.1"})
public final class SpectreEnergyCommand {
    @NotNull
    public static final SpectreEnergyCommand INSTANCE = new SpectreEnergyCommand();
    @NotNull
    private static final String PLAYER = "player";
    @NotNull
    private static final String AMOUNT = "amount";

    private SpectreEnergyCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"spectre-energy").then((ArgumentBuilder)this.createGetCommand())).then((ArgumentBuilder)this.createSetCommand());
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> createSetCommand() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").requires(SpectreEnergyCommand::createSetCommand$lambda$0)).then(Commands.argument((String)AMOUNT, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(SpectreEnergyCommand::createSetCommand$lambda$1))).then(Commands.argument((String)PLAYER, (ArgumentType)((ArgumentType)EntityArgument.player())).then(Commands.argument((String)AMOUNT, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)0))).executes(SpectreEnergyCommand::createSetCommand$lambda$2)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> createGetCommand() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").requires(SpectreEnergyCommand::createGetCommand$lambda$3)).executes(SpectreEnergyCommand::createGetCommand$lambda$4)).then(Commands.argument((String)PLAYER, (ArgumentType)((ArgumentType)EntityArgument.player())).executes(SpectreEnergyCommand::createGetCommand$lambda$5));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private final int setSpectreEnergy(CommandSourceStack source, ServerPlayer player, int amount) {
        ServerLevel serverLevel = player.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
        SpectreEnergyHandler handler = SpectreEnergyHandler.Companion.get(serverLevel);
        handler.setStoredEnergy((Player)player, amount);
        String string = "%,d";
        Object[] objectArray = new Object[]{amount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String amountString = string2;
        source.sendSuccess(() -> SpectreEnergyCommand.setSpectreEnergy$lambda$6(player, amountString), true);
        return 1;
    }

    private final int getSpectreEnergy(CommandSourceStack source, ServerPlayer player) {
        ServerLevel serverLevel = player.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
        SpectreEnergyHandler handler = SpectreEnergyHandler.Companion.get(serverLevel);
        int stored = handler.getStoredEnergy((Player)player);
        String string = "%,d";
        Object[] objectArray = new Object[]{stored};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String amountString = string2;
        source.sendSuccess(() -> SpectreEnergyCommand.getSpectreEnergy$lambda$7(player, amountString), false);
        return 1;
    }

    private static final boolean createSetCommand$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int createSetCommand$lambda$1(CommandContext it) {
        CommandSourceStack source = (CommandSourceStack)it.getSource();
        ServerPlayer player = source.getPlayerOrException();
        int amount = IntegerArgumentType.getInteger((CommandContext)it, (String)AMOUNT);
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.setSpectreEnergy(source, player, amount);
    }

    private static final int createSetCommand$lambda$2(CommandContext it) {
        CommandSourceStack source = (CommandSourceStack)it.getSource();
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)it, (String)PLAYER);
        int amount = IntegerArgumentType.getInteger((CommandContext)it, (String)AMOUNT);
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.setSpectreEnergy(source, player, amount);
    }

    private static final boolean createGetCommand$lambda$3(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int createGetCommand$lambda$4(CommandContext it) {
        CommandSourceStack source = (CommandSourceStack)it.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.getSpectreEnergy(source, player);
    }

    private static final int createGetCommand$lambda$5(CommandContext it) {
        CommandSourceStack source = (CommandSourceStack)it.getSource();
        ServerPlayer player = EntityArgument.getPlayer((CommandContext)it, (String)PLAYER);
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)player);
        return INSTANCE.getSpectreEnergy(source, player);
    }

    private static final Component setSpectreEnergy$lambda$6(ServerPlayer $player, String $amountString) {
        Object[] objectArray = new Object[]{$player.getName(), $amountString};
        return (Component)ModLanguageProvider.Companion.toComponent("command.irregular_implements.spectre_energy.set", objectArray);
    }

    private static final Component getSpectreEnergy$lambda$7(ServerPlayer $player, String $amountString) {
        Object[] objectArray = new Object[]{$player.getName(), $amountString};
        return (Component)ModLanguageProvider.Companion.toComponent("command.irregular_implements.spectre_energy.get", objectArray);
    }
}

