/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.effect;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.registry.ModEffects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/effect/ImbueEffect;", "Lnet/minecraft/world/effect/MobEffect;", "color", "", "<init>", "(I)V", "onEffectStarted", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "amplifier", "Companion", "irregular-implements-1.21.1"})
public final class ImbueEffect
extends MobEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ImbueEffect(int color) {
        super(MobEffectCategory.BENEFICIAL, color);
    }

    public void onEffectStarted(@NotNull LivingEntity livingEntity, int amplifier) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Collection collection = livingEntity.getActiveEffects();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
        List currentPotions = CollectionsKt.toList((Iterable)collection);
        for (MobEffectInstance effect : currentPotions) {
            if (!(effect.getEffect().value() instanceof ImbueEffect) || Intrinsics.areEqual((Object)effect.getEffect().value(), (Object)((Object)this))) continue;
            livingEntity.removeEffect(effect.getEffect());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/effect/ImbueEffect$Companion;", "", "<init>", "()V", "handleAttackImbues", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "handleDamageImbue", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "handleXpImbue", "Lnet/neoforged/neoforge/event/entity/living/LivingExperienceDropEvent;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nImbueEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImbueEffect.kt\ndev/aaronhowser/mods/irregular_implements/effect/ImbueEffect$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1563#2:90\n1634#2,3:91\n808#2,11:94\n*S KotlinDebug\n*F\n+ 1 ImbueEffect.kt\ndev/aaronhowser/mods/irregular_implements/effect/ImbueEffect$Companion\n*L\n46#1:90\n46#1:91,3\n47#1:94,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void handleAttackImbues(@NotNull LivingDamageEvent.Post event) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            DamageSource damageSource = event.getSource();
            if (!damageSource.isDirect()) {
                return;
            }
            if (!damageSource.is(DamageTypes.MOB_ATTACK) && !damageSource.is(DamageTypes.PLAYER_ATTACK)) {
                return;
            }
            Entity entity = event.getSource().getEntity();
            LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity == null) {
                return;
            }
            LivingEntity attacker = livingEntity;
            LivingEntity target = event.getEntity();
            Collection collection = attacker.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            boolean $i$f$map = false;
            ImbueEffect imbueEffect = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MobEffectInstance mobEffectInstance = (MobEffectInstance)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((MobEffect)it.getEffect().value());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ImbueEffect)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List imbues = (List)destination$iv$iv;
            for (ImbueEffect imbue : imbues) {
                imbueEffect = imbue;
                if (Intrinsics.areEqual((Object)((Object)imbueEffect), (Object)ModEffects.INSTANCE.getFIRE_IMBUE().get())) {
                    target.igniteForSeconds(10.0f);
                    continue;
                }
                if (Intrinsics.areEqual((Object)((Object)imbueEffect), (Object)ModEffects.INSTANCE.getPOISON_IMBUE().get())) {
                    target.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1));
                    continue;
                }
                if (Intrinsics.areEqual((Object)((Object)imbueEffect), (Object)ModEffects.INSTANCE.getWITHER_IMBUE().get())) {
                    target.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 1));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)((Object)imbueEffect), (Object)ModEffects.INSTANCE.getCOLLAPSE_IMBUE().get())) continue;
                target.addEffect(new MobEffectInstance((Holder)ModEffects.COLLAPSE, 200, 0));
            }
        }

        public final void handleDamageImbue(@NotNull LivingIncomingDamageEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCanceled()) {
                return;
            }
            LivingEntity entity = event.getEntity();
            DamageSource damageSource = event.getSource();
            if (damageSource.is(DamageTypeTags.BYPASSES_EFFECTS) || damageSource.is(DamageTypeTags.BYPASSES_RESISTANCE) || damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return;
            }
            if (entity.hasEffect((Holder)ModEffects.INSTANCE.getSPECTRE_IMBUE()) && (double)entity.getRandom().nextFloat() <= ((Number)ServerConfig.Companion.getCONFIG().getSpectreImbueChance().get()).doubleValue()) {
                event.setCanceled(true);
                entity.invulnerableTime = 20;
            }
        }

        public final void handleXpImbue(@NotNull LivingExperienceDropEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Player player = event.getAttackingPlayer();
            if (player == null) {
                return;
            }
            Player attacker = player;
            if (attacker.hasEffect((Holder)ModEffects.INSTANCE.getEXPERIENCE_IMBUE())) {
                event.setDroppedExperience(Mth.ceil((float)((float)event.getDroppedExperience() * 1.5f)));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

