/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.irregular_implements.handler.SpectreIlluminationHandler;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00102\u001a\u00020\n2\u0006\u00103\u001a\u000204H\u0016R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020%2\u0006\u0010$\u001a\u00020%8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00066"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/SpectreIlluminatorEntity;", "Lnet/minecraft/world/entity/Entity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "isPickable", "", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "interact", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "removedByEntity", "", "entity", "getPickResult", "Lnet/minecraft/world/item/ItemStack;", "onAddedToLevel", "remove", "reason", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "destination", "Lnet/minecraft/world/phys/Vec3;", "tick", "moveToDestination", "recalculateDestination", "value", "", "actionTimer", "getActionTimer", "()I", "setActionTimer", "(I)V", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "shouldRenderAtSqrDistance", "distance", "", "Companion", "irregular-implements-1.21.1"})
public final class SpectreIlluminatorEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3 destination;
    public static final int HEIGHT_ABOVE_MAX_BLOCK = 50;
    public static final double MAX_VARIATION = 5.0;
    public static final int TICKS_TO_MAX_SIZE = 1200;
    @NotNull
    private static final EntityDataAccessor<Integer> ACTION_TIMER;
    @NotNull
    public static final String ACTION_TIMER_NBT = "ActionTimer";

    public SpectreIlluminatorEntity(@NotNull EntityType<?> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.destination = vec3;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity entity = source.getEntity();
        if (entity == null) {
            return false;
        }
        Entity entity2 = entity;
        this.removedByEntity(entity2);
        return false;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        this.removedByEntity((Entity)player);
        return InteractionResult.SUCCESS;
    }

    private final void removedByEntity(Entity entity) {
        if (entity instanceof Player) {
            if (((Player)entity).hasInfiniteMaterials()) {
                this.discard();
            } else {
                this.kill();
            }
        } else {
            this.kill();
        }
    }

    @Nullable
    public ItemStack getPickResult() {
        return ModItems.INSTANCE.getSPECTRE_ILLUMINATOR().toStack();
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            SpectreIlluminationHandler.Companion.setChunkIlluminated(serverLevel, blockPos, true);
        }
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super.remove(reason);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            SpectreIlluminationHandler.Companion.setChunkIlluminated(serverLevel, blockPos, false);
            if (this.getRemovalReason() == Entity.RemovalReason.KILLED) {
                ItemStack itemStack = ModItems.INSTANCE.getSPECTRE_ILLUMINATOR().toStack();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
                OtherUtil.dropStackAt$default(OtherUtil.INSTANCE, itemStack, this, false, 4, null);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.getActionTimer() < 1200) {
            int n = this.getActionTimer();
            this.setActionTimer(n + 1);
        }
        this.moveToDestination();
    }

    private final void moveToDestination() {
        if (Intrinsics.areEqual((Object)this.destination, (Object)Vec3.ZERO) || this.tickCount % 1200 == 0) {
            this.recalculateDestination();
        }
        if (Intrinsics.areEqual((Object)this.position(), (Object)this.destination)) {
            return;
        }
        double distance = this.position().distanceTo(this.destination);
        if (distance < 0.1) {
            this.setPos(this.destination);
            return;
        }
        Vec3 newPos = this.position().lerp(this.destination, 0.001);
        this.setPos(newPos);
    }

    private final void recalculateDestination() {
        ChunkPos chunkPos = new ChunkPos(this.blockPosition());
        LevelChunk chunk = this.level().getChunk(chunkPos.x, chunkPos.z);
        int highestBlock = this.level().getMinBuildHeight();
        block0: for (int dX = 0; dX < 16; ++dX) {
            for (int dZ = 0; dZ < 16; ++dZ) {
                int height = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, dX, dZ);
                if (height > highestBlock) {
                    highestBlock = height;
                }
                if (highestBlock >= this.level().getMaxBuildHeight()) continue block0;
            }
        }
        Random random = RandomKt.Random((long)chunkPos.toLong());
        double x = (double)chunkPos.getMiddleBlockX() + random.nextDouble(-5.0, 5.0);
        double y = (double)highestBlock + (double)50 + random.nextDouble(-5.0, 0.0);
        double z = (double)chunkPos.getMiddleBlockZ() + random.nextDouble(-5.0, 5.0);
        this.destination = new Vec3(x, y, z);
    }

    public SpectreIlluminatorEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = ModEntityTypes.INSTANCE.getSPECTRE_ILLUMINATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType)object, level);
    }

    public final int getActionTimer() {
        Object object = this.entityData.get(ACTION_TIMER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void setActionTimer(int value) {
        this.entityData.set(ACTION_TIMER, (Object)value);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(ACTION_TIMER, (Object)0);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.setActionTimer(compound.getInt(ACTION_TIMER_NBT));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.putInt(ACTION_TIMER_NBT, this.getActionTimer());
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < Math.pow(64.0 * Entity.getViewScale(), 4);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(SpectreIlluminatorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        ACTION_TIMER = entityDataAccessor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/SpectreIlluminatorEntity$Companion;", "", "<init>", "()V", "HEIGHT_ABOVE_MAX_BLOCK", "", "MAX_VARIATION", "", "TICKS_TO_MAX_SIZE", "ACTION_TIMER", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getACTION_TIMER", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "ACTION_TIMER_NBT", "", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getACTION_TIMER() {
            return ACTION_TIMER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

