/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/SpectreEnergyHandler;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "playerStoredEnergy", "", "Ljava/util/UUID;", "", "cachedEnergyInjectors", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "cachedCoils", "getStoredEnergy", "player", "Lnet/minecraft/world/entity/player/Player;", "setStoredEnergy", "", "energy", "getEnergyInjector", "ownerUuid", "getCoil", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "Companion", "irregular-implements-1.21.1"})
public final class SpectreEnergyHandler
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, Integer> playerStoredEnergy = new LinkedHashMap();
    @NotNull
    private final Map<UUID, IEnergyStorage> cachedEnergyInjectors = new LinkedHashMap();
    @NotNull
    private final Map<UUID, IEnergyStorage> cachedCoils = new LinkedHashMap();
    @NotNull
    public static final String OLD_SAVED_DATA_NAME = "spectre_coil";
    @NotNull
    public static final String SAVED_DATA_NAME = "ii_spectre_energy";
    @NotNull
    public static final String PLAYER_ENERGIES_NBT = "player_energies";
    @NotNull
    public static final String PLAYER_ENERGIES_NBT_OLD = "coil_entries";
    @NotNull
    public static final String UUID_NBT = "uuid";
    @NotNull
    public static final String ENERGY_NBT = "energy";

    public final int getStoredEnergy(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return ((Number)this.playerStoredEnergy.getOrDefault(uUID, 0)).intValue();
    }

    public final void setStoredEnergy(@NotNull Player player, int energy) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.playerStoredEnergy.put(player.getUUID(), RangesKt.coerceIn((int)energy, (int)0, (int)Companion.getMaxEnergy()));
        this.setDirty();
    }

    @NotNull
    public final IEnergyStorage getEnergyInjector(@NotNull UUID ownerUuid) {
        Intrinsics.checkNotNullParameter((Object)ownerUuid, (String)"ownerUuid");
        IEnergyStorage existing = this.cachedEnergyInjectors.get(ownerUuid);
        if (existing != null) {
            return existing;
        }
        IEnergyStorage iEnergyStorage = new IEnergyStorage(this, ownerUuid){
            final /* synthetic */ SpectreEnergyHandler this$0;
            final /* synthetic */ UUID $ownerUuid;
            {
                this.this$0 = $receiver;
                this.$ownerUuid = $ownerUuid;
            }

            public int receiveEnergy(int toReceive, boolean simulate) {
                int currentEnergy = ((Number)SpectreEnergyHandler.access$getPlayerStoredEnergy$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
                int max = this.getMaxEnergyStored();
                int newEnergy = (int)RangesKt.coerceIn((long)((long)currentEnergy + (long)toReceive), (long)0L, (long)max);
                int actualReceived = newEnergy - currentEnergy;
                if (!simulate) {
                    Integer n = newEnergy;
                    SpectreEnergyHandler.access$getPlayerStoredEnergy$p(this.this$0).put(this.$ownerUuid, n);
                }
                this.this$0.setDirty();
                return actualReceived;
            }

            public int getEnergyStored() {
                return ((Number)SpectreEnergyHandler.access$getPlayerStoredEnergy$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                return 0;
            }

            public int getMaxEnergyStored() {
                return SpectreEnergyHandler.Companion.getMaxEnergy();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        };
        this.cachedEnergyInjectors.put(ownerUuid, iEnergyStorage);
        return iEnergyStorage;
    }

    @NotNull
    public final IEnergyStorage getCoil(@NotNull UUID ownerUuid) {
        Intrinsics.checkNotNullParameter((Object)ownerUuid, (String)"ownerUuid");
        IEnergyStorage existing = this.cachedCoils.get(ownerUuid);
        if (existing != null) {
            return existing;
        }
        IEnergyStorage iEnergyStorage = new IEnergyStorage(this, ownerUuid){
            final /* synthetic */ SpectreEnergyHandler this$0;
            final /* synthetic */ UUID $ownerUuid;
            {
                this.this$0 = $receiver;
                this.$ownerUuid = $ownerUuid;
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                int currentEntity = ((Number)SpectreEnergyHandler.access$getPlayerStoredEnergy$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
                int newEnergy = Math.max(0, currentEntity - toExtract);
                if (!simulate) {
                    Integer n = newEnergy;
                    SpectreEnergyHandler.access$getPlayerStoredEnergy$p(this.this$0).put(this.$ownerUuid, n);
                }
                this.this$0.setDirty();
                return currentEntity - newEnergy;
            }

            public int getEnergyStored() {
                return ((Number)SpectreEnergyHandler.access$getPlayerStoredEnergy$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
            }

            public int receiveEnergy(int toReceive, boolean simulate) {
                return 0;
            }

            public int getMaxEnergyStored() {
                return SpectreEnergyHandler.Companion.getMaxEnergy();
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return false;
            }
        };
        this.cachedCoils.put(ownerUuid, iEnergyStorage);
        return iEnergyStorage;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag listTag = tag.getList(PLAYER_ENERGIES_NBT, 10);
        for (Map.Entry<UUID, Integer> entry2 : this.playerStoredEnergy.entrySet()) {
            UUID uuid = entry2.getKey();
            int energy = ((Number)entry2.getValue()).intValue();
            CompoundTag entryTag = new CompoundTag();
            entryTag.putString(UUID_NBT, uuid.toString());
            entryTag.putInt(ENERGY_NBT, energy);
            listTag.add((Object)entryTag);
        }
        return tag;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/SpectreEnergyHandler$Companion;", "", "<init>", "()V", "OLD_SAVED_DATA_NAME", "", "SAVED_DATA_NAME", "PLAYER_ENERGIES_NBT", "PLAYER_ENERGIES_NBT_OLD", "UUID_NBT", "ENERGY_NBT", "getMaxEnergy", "", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/SpectreEnergyHandler;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nSpectreEnergyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpectreEnergyHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/SpectreEnergyHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMaxEnergy() {
            Object object = ServerConfig.Companion.getCONFIG().getSpectreBufferCapacity().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        private final SpectreEnergyHandler load(CompoundTag tag, HolderLookup.Provider provider) {
            Collection collection;
            SpectreEnergyHandler spectreEnergyHandler = new SpectreEnergyHandler();
            ListTag newListTag = tag.getList(SpectreEnergyHandler.PLAYER_ENERGIES_NBT, 10);
            ListTag oldListTag = tag.getList(SpectreEnergyHandler.PLAYER_ENERGIES_NBT_OLD, 10);
            Collection collection2 = (Collection)newListTag;
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = oldListTag;
            } else {
                collection = collection2;
            }
            ListTag listTag = (ListTag)collection;
            Intrinsics.checkNotNull((Object)listTag);
            int n = ((Collection)listTag).size();
            for (int i = 0; i < n; ++i) {
                CompoundTag entryTag = listTag.getCompound(i);
                UUID uuid = UUID.fromString(entryTag.getString(SpectreEnergyHandler.UUID_NBT));
                int energy = entryTag.getInt(SpectreEnergyHandler.ENERGY_NBT);
                Integer n2 = energy;
                spectreEnergyHandler.playerStoredEnergy.put(uuid, n2);
            }
            return spectreEnergyHandler;
        }

        @NotNull
        public final SpectreEnergyHandler get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!Intrinsics.areEqual((Object)level, (Object)level.getServer().overworld())) {
                ServerLevel serverLevel = level.getServer().overworld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
                return this.get(serverLevel);
            }
            DimensionDataStorage storage = level.getDataStorage();
            SavedData.Factory factory = new SavedData.Factory(SpectreEnergyHandler::new, this::load);
            Intrinsics.checkNotNull((Object)storage);
            Object t = OtherUtil.INSTANCE.updateSavedDataLocation(storage, factory, SpectreEnergyHandler.SAVED_DATA_NAME, SpectreEnergyHandler.OLD_SAVED_DATA_NAME);
            Intrinsics.checkNotNullExpressionValue(t, (String)"updateSavedDataLocation(...)");
            return (SpectreEnergyHandler)((Object)t);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

